/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.distribution;

import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.Likelihood;
import dr.inference.model.MatrixParameter;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.GammaFunction;
import dr.math.MathUtils;
import dr.math.distributions.GWishartStatistics;
import dr.math.distributions.MultivariateDistribution;
import dr.math.distributions.WishartStatistics;
import dr.math.matrixAlgebra.CholeskyDecomposition;
import dr.math.matrixAlgebra.IllegalDimension;
import dr.math.matrixAlgebra.Matrix;
import dr.math.matrixAlgebra.SymmetricMatrix;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.Arrays;

public class GWishartLikelihood
extends AbstractModelLikelihood
implements MultivariateDistribution,
GWishartStatistics,
WishartStatistics {
    public static final String DF = "df";
    public static final String RATE_MATRIX = "rateMatrix";
    public static final String ADJ_INDICATORS = "adjIndicators";
    public static final String GWISHART_LIKELIHOOD = "GWishartLikelihood";
    public static final String GWISHART_PRIOR = "multivariateGWishartPrior";
    public static final String NON_INFORMATIVE = "nonInformative";
    public static final String DATA = "data";
    private double df;
    private int dim;
    private double[][] rateMatrix;
    private double[][] scaleMatrix;
    public final MatrixParameter precisionParameter;
    public final Parameter adjParameter;
    public double[][] adjMatrix;
    private double[] D;
    private Matrix DMat;
    private double[] S;
    private Matrix SMat;
    private boolean logNormalizationConstantKnown = false;
    private double storedLogNormalizationConstant;
    private double logNormalizationConstant;
    protected double logLikelihood;
    private double storedLogLikelihood;
    protected boolean logLikelihoodKnown = false;
    public static XMLObjectParser GWISHART_PRIOR_PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newBooleanRule("nonInformative", true), AttributeRule.newDoubleRule("df", true), new ElementRule("rateMatrix", new XMLSyntaxRule[]{new ElementRule(MatrixParameter.class)}, true), new ElementRule("adjIndicators", new XMLSyntaxRule[]{new ElementRule(Parameter.class)}, true), new ElementRule("data", new XMLSyntaxRule[]{new ElementRule(MatrixParameter.class, 1, Integer.MAX_VALUE)})};

        @Override
        public String getParserName() {
            return GWishartLikelihood.GWISHART_PRIOR;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            GWishartLikelihood gWishartLikelihood;
            if (xMLObject.hasAttribute(GWishartLikelihood.NON_INFORMATIVE) && xMLObject.getBooleanAttribute(GWishartLikelihood.NON_INFORMATIVE)) {
                XMLObject xMLObject2 = xMLObject.getChild(GWishartLikelihood.DATA);
                int n = ((MatrixParameter)xMLObject2.getChild(0)).getColumnDimension();
                gWishartLikelihood = new GWishartLikelihood(n);
            } else {
                if (!(xMLObject.hasAttribute(GWishartLikelihood.DF) && xMLObject.hasChildNamed(GWishartLikelihood.RATE_MATRIX) && xMLObject.hasChildNamed(GWishartLikelihood.ADJ_INDICATORS))) {
                    throw new XMLParseException("Must specify df, rateMatrix and adjIndicators");
                }
                double d = xMLObject.getDoubleAttribute(GWishartLikelihood.DF);
                XMLObject xMLObject3 = xMLObject.getChild(GWishartLikelihood.RATE_MATRIX);
                MatrixParameter matrixParameter = (MatrixParameter)xMLObject3.getChild(MatrixParameter.class);
                xMLObject3 = xMLObject.getChild(GWishartLikelihood.ADJ_INDICATORS);
                Parameter parameter = (Parameter)xMLObject3.getChild(Parameter.class);
                xMLObject3 = xMLObject.getChild(GWishartLikelihood.DATA);
                MatrixParameter matrixParameter2 = (MatrixParameter)xMLObject3.getChild(Parameter.class);
                gWishartLikelihood = new GWishartLikelihood(matrixParameter2, d, matrixParameter.getParameterAsMatrix(), parameter, false);
            }
            return gWishartLikelihood;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public String getParserDescription() {
            return "Calculates the likelihood of some data (Precision Matrix) under a G-Wishart distribution.";
        }

        @Override
        public Class getReturnType() {
            return Likelihood.class;
        }
    };

    public GWishartLikelihood(MatrixParameter matrixParameter, double d, double[][] dArray, Parameter parameter, boolean bl) {
        super(GWISHART_LIKELIHOOD);
        int n;
        this.df = d;
        this.dim = dArray.length;
        this.precisionParameter = matrixParameter;
        this.addVariable(matrixParameter);
        if (parameter == null) {
            this.adjParameter = new Parameter.Default(this.dim * (this.dim - 1) / 2, 1.0);
        } else {
            this.adjParameter = parameter;
            this.addVariable(parameter);
        }
        this.adjMatrix = SymmetricMatrix.compoundSymmetricMatrix(new double[this.dim], parameter.getParameterValues(), this.dim).toComponents();
        for (int i = 0; i < this.dim; ++i) {
            for (n = 0; n <= i; ++n) {
                this.adjMatrix[i][n] = 0.0;
            }
        }
        if (bl) {
            this.scaleMatrix = dArray;
            this.SMat = new Matrix(this.scaleMatrix);
            double[][] dArray2 = this.SMat.toComponents();
            this.S = new double[this.dim * this.dim];
            for (n = 0; n < this.dim; ++n) {
                System.arraycopy(dArray2[n], 0, this.S, n * this.dim, this.dim);
            }
            this.DMat = this.SMat.inverse();
            double[][] dArray3 = this.DMat.toComponents();
            this.D = new double[this.dim * this.dim];
            for (int i = 0; i < this.dim; ++i) {
                System.arraycopy(dArray3[i], 0, this.D, i * this.dim, this.dim);
            }
            this.rateMatrix = this.SMat.inverse().toComponents();
        } else {
            this.rateMatrix = dArray;
            this.DMat = new Matrix(this.rateMatrix);
            double[][] dArray4 = this.DMat.toComponents();
            this.D = new double[this.dim * this.dim];
            for (n = 0; n < this.dim; ++n) {
                System.arraycopy(dArray4[n], 0, this.D, n * this.dim, this.dim);
            }
            this.SMat = this.DMat.inverse();
            double[][] dArray5 = this.SMat.toComponents();
            this.S = new double[this.dim * this.dim];
            for (int i = 0; i < this.dim; ++i) {
                System.arraycopy(dArray5[i], 0, this.S, i * this.dim, this.dim);
            }
            this.scaleMatrix = this.DMat.inverse().toComponents();
        }
        this.computeNormalizationConstant();
    }

    public GWishartLikelihood(int n) {
        super(GWISHART_LIKELIHOOD);
        this.df = 0.0;
        this.scaleMatrix = null;
        this.rateMatrix = null;
        this.adjMatrix = null;
        this.adjParameter = null;
        this.precisionParameter = null;
        this.dim = n;
        this.logNormalizationConstant = 0.0;
    }

    private void computeNormalizationConstant() {
        this.logNormalizationConstant = GWishartLikelihood.computeNormalizationConstant(this.df, this.scaleMatrix, this.adjParameter, this.dim);
    }

    public static double computeNormalizationConstant(double d, double[][] dArray, Parameter parameter, int n) {
        if (d == 0.0) {
            return 0.0;
        }
        double[][] dArray2 = SymmetricMatrix.compoundSymmetricMatrix(new double[n], parameter.getParameterValues(), n).toComponents();
        if (GWishartLikelihood.getGraphSize(dArray2) == (double)(n * (n - 1) / 2)) {
            Matrix matrix = new Matrix(dArray);
            double d2 = d + (double)n - 1.0;
            double d3 = 0.0;
            try {
                d3 = -d2 / 2.0 * Math.log(matrix.determinant());
            }
            catch (IllegalDimension illegalDimension) {
                illegalDimension.printStackTrace();
            }
            d3 -= d2 * (double)n / 2.0 * Math.log(2.0);
            d3 -= (double)(n * (n - 1)) / 4.0 * Math.log(Math.PI);
            for (int i = 1; i <= n; ++i) {
                d3 -= GammaFunction.lnGamma((d2 + 1.0 - (double)i) / 2.0);
            }
            return d3;
        }
        double[] dArray3 = GWishartLikelihood.rowSums(dArray2);
        double[] dArray4 = GWishartLikelihood.colSums(dArray2);
        double[][] dArray5 = GWishartLikelihood.getTMatrix(dArray);
        double[][] dArray6 = GWishartLikelihood.getHMatrix(dArray5);
        int n2 = 200;
        double d4 = GWishartLikelihood.getFD(d, dArray6, dArray2, dArray3, n, n2);
        double d5 = 0.0;
        for (int i = 0; i < n; ++i) {
            d5 += (d + 2.0 * dArray3[i]) / 2.0 * Math.log(2.0) + dArray3[i] / 2.0 * Math.log(Math.PI) + GammaFunction.lnGamma((d + dArray3[i]) / 2.0) + (d + dArray3[i] + dArray4[i]) * Math.log(dArray5[i][i]);
        }
        if (Double.isInfinite(d5) || Double.isNaN(d5)) {
            return Double.NaN;
        }
        double d6 = d5 + Math.log(d4);
        return -d6;
    }

    public static double computeNormalizationConstant(double d, double[][] dArray, double[][] dArray2, int n) {
        if (d == 0.0) {
            return 0.0;
        }
        if (GWishartLikelihood.getGraphSize(dArray2) == (double)(n * (n - 1) / 2)) {
            Matrix matrix = new Matrix(dArray);
            double d2 = d + (double)n - 1.0;
            double d3 = 0.0;
            try {
                d3 = -d2 / 2.0 * Math.log(matrix.determinant());
            }
            catch (IllegalDimension illegalDimension) {
                illegalDimension.printStackTrace();
            }
            d3 -= d2 * (double)n / 2.0 * Math.log(2.0);
            d3 -= (double)(n * (n - 1)) / 4.0 * Math.log(Math.PI);
            for (int i = 1; i <= n; ++i) {
                d3 -= GammaFunction.lnGamma((d2 + 1.0 - (double)i) / 2.0);
            }
            return d3;
        }
        double[] dArray3 = GWishartLikelihood.rowSums(dArray2);
        double[] dArray4 = GWishartLikelihood.colSums(dArray2);
        double[][] dArray5 = GWishartLikelihood.getTMatrix(dArray);
        double[][] dArray6 = GWishartLikelihood.getHMatrix(dArray5);
        int n2 = 200;
        double d4 = GWishartLikelihood.getFD(d, dArray6, dArray2, dArray3, n, n2);
        double d5 = 0.0;
        for (int i = 0; i < n; ++i) {
            d5 += (d + 2.0 * dArray3[i]) / 2.0 * Math.log(2.0) + dArray3[i] / 2.0 * Math.log(Math.PI) + GammaFunction.lnGamma((d + dArray3[i]) / 2.0) + (d + dArray3[i] + dArray4[i]) * Math.log(dArray5[i][i]);
        }
        if (Double.isInfinite(d5) || Double.isNaN(d5)) {
            return Double.NaN;
        }
        double d6 = d5 + Math.log(d4);
        return -d6;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        if (variable instanceof Parameter) {
            this.logNormalizationConstantKnown = false;
        }
        if (variable instanceof MatrixParameter) {
            this.logLikelihoodKnown = false;
        }
    }

    @Override
    public void storeState() {
        this.storedLogNormalizationConstant = this.logNormalizationConstant;
        this.storedLogLikelihood = this.logLikelihood;
    }

    @Override
    public void restoreState() {
        this.logNormalizationConstant = this.storedLogNormalizationConstant;
        this.logNormalizationConstantKnown = true;
        this.logLikelihood = this.storedLogLikelihood;
        this.logLikelihoodKnown = true;
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public void makeDirty() {
        this.logLikelihoodKnown = false;
    }

    @Override
    public Model getModel() {
        return this;
    }

    @Override
    public final double getLogLikelihood() {
        if (!this.logNormalizationConstantKnown) {
            this.logNormalizationConstant = GWishartLikelihood.computeNormalizationConstant(this.df, this.scaleMatrix, this.adjParameter, this.dim);
            this.logNormalizationConstantKnown = true;
            this.logLikelihood = this.calculateLogLikelihood();
            this.logLikelihoodKnown = true;
            return this.logLikelihood;
        }
        if (!this.logLikelihoodKnown) {
            this.logLikelihood = this.calculateLogLikelihood();
            this.logLikelihoodKnown = true;
        }
        return this.logLikelihood;
    }

    protected double calculateLogLikelihood() {
        Matrix matrix = new Matrix(this.precisionParameter.getParameterValues(), this.dim, this.dim);
        return GWishartLikelihood.logPdf(matrix, this.DMat, this.df, this.dim, this.logNormalizationConstant);
    }

    public GWishartLikelihood getDistribution() {
        return this;
    }

    @Override
    public String getType() {
        return GWISHART_PRIOR;
    }

    @Override
    public double[][] getRateMatrix() {
        return this.rateMatrix;
    }

    @Override
    public double[][] getScaleMatrix() {
        return this.scaleMatrix;
    }

    @Override
    public double[] getMean() {
        return null;
    }

    @Override
    public double getDF() {
        return this.df;
    }

    @Override
    public Parameter getAdjParameter() {
        return this.adjParameter;
    }

    @Override
    public double[][] getAdjMatrix() {
        return SymmetricMatrix.compoundSymmetricMatrix(new double[this.dim], this.adjParameter.getParameterValues(), this.dim).toComponents();
    }

    public static double getGraphSize(double[][] dArray) {
        int n = dArray.length;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            for (int j = i; j < n; ++j) {
                d += dArray[i][j];
            }
        }
        return d;
    }

    public static double[] rowSums(double[][] dArray) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            double d = 0.0;
            for (int j = i; j < n; ++j) {
                d += dArray[i][j];
            }
            dArray2[i] = d;
        }
        return dArray2;
    }

    public static double[] colSums(double[][] dArray) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            int n2 = 0;
            for (int j = 0; j < i; ++j) {
                n2 = (int)((double)n2 + dArray[j][i]);
            }
            dArray2[i] = n2;
        }
        return dArray2;
    }

    public static double[][] getTMatrix(double[][] dArray) {
        int n = dArray.length;
        double[][] dArray2 = dArray;
        try {
            dArray2 = new CholeskyDecomposition(dArray2).getL();
        }
        catch (IllegalDimension illegalDimension) {
            throw new RuntimeException("Numerical exception in GWishartLikelihood");
        }
        double[][] dArray3 = new double[n][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                dArray3[i][j] = dArray2[j][i];
            }
        }
        return dArray3;
    }

    public static double[][] getHMatrix(double[][] dArray) {
        int n = dArray.length;
        double[][] dArray2 = new double[n][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                dArray2[i][j] = dArray[i][j] / dArray[j][j];
            }
        }
        return dArray2;
    }

    private static boolean isDiagonal(double[][] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = i + 1; j < dArray.length; ++j) {
                if (dArray[i][j] == 0.0) continue;
                return false;
            }
        }
        return true;
    }

    public static double getFD(double d, double[][] dArray, double[][] dArray2, double[] dArray3, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        double d2 = 1.7976931348623156E305;
        double d3 = 4.94E-321;
        double[] dArray4 = new double[n2];
        double[][] dArray5 = new double[n][n];
        if (GWishartLikelihood.isDiagonal(dArray)) {
            for (n6 = 0; n6 < n2; ++n6) {
                for (n5 = 0; n5 < n; ++n5) {
                    dArray5[n5][n5] = Math.sqrt(MathUtils.nextGamma((d + dArray3[n5]) * 0.5, 0.5));
                }
                for (n5 = 0; n5 < n - 1; ++n5) {
                    for (n4 = n5 + 1; n4 < n; ++n4) {
                        dArray5[n5][n4] = dArray2[n5][n4] == 1.0 ? MathUtils.nextGaussian() : 0.0;
                    }
                }
                for (n5 = 0; n5 < n - 1; ++n5) {
                    for (n4 = n5 + 1; n4 < n; ++n4) {
                        if (dArray2[n5][n4] != 0.0) continue;
                        dArray5[n5][n4] = 0.0;
                        if (n5 > 0) {
                            double d4 = 0.0;
                            for (n3 = 0; n3 < n5; ++n3) {
                                if (d4 == Double.POSITIVE_INFINITY) {
                                    d4 = d2;
                                }
                                if (d4 == Double.NEGATIVE_INFINITY) {
                                    d4 = d3;
                                }
                                d4 += dArray5[n3][n5] * dArray5[n3][n4];
                            }
                            if (d4 == Double.POSITIVE_INFINITY) {
                                d4 = d2;
                            }
                            if (d4 == Double.NEGATIVE_INFINITY) {
                                d4 = d3;
                            }
                            dArray5[n5][n4] = -d4 / dArray5[n5][n5];
                        }
                        if (dArray5[n5][n4] == Double.POSITIVE_INFINITY) {
                            dArray5[n5][n4] = d2;
                        }
                        if (dArray5[n5][n4] == Double.NEGATIVE_INFINITY) {
                            dArray5[n5][n4] = d3;
                        }
                        int n7 = n6;
                        dArray4[n7] = dArray4[n7] + dArray5[n5][n4] * dArray5[n5][n4];
                    }
                }
                if (dArray4[n6] != Double.POSITIVE_INFINITY) continue;
                dArray4[n6] = d2;
            }
        } else {
            for (n6 = 0; n6 < n2; ++n6) {
                for (n5 = 0; n5 < n; ++n5) {
                    dArray5[n5][n5] = Math.sqrt(MathUtils.nextGamma((d + dArray3[n5]) * 0.5, 0.5));
                }
                for (n5 = 0; n5 < n - 1; ++n5) {
                    for (n4 = n5 + 1; n4 < n; ++n4) {
                        dArray5[n5][n4] = dArray2[n5][n4] == 1.0 ? MathUtils.nextGaussian() : 0.0;
                    }
                }
                for (n5 = 0; n5 < n - 1; ++n5) {
                    for (n4 = n5 + 1; n4 < n; ++n4) {
                        if (dArray2[n5][n4] != 0.0) continue;
                        double d5 = 0.0;
                        for (n3 = n5; n3 < n4; ++n3) {
                            if (d5 == Double.POSITIVE_INFINITY) {
                                d5 = d2;
                            }
                            if (d5 == Double.NEGATIVE_INFINITY) {
                                d5 = d3;
                            }
                            d5 += dArray5[n5][n3] * dArray[n3][n4];
                        }
                        dArray5[n5][n4] = -d5;
                        if (n5 > 0) {
                            for (n3 = 0; n3 < n5; ++n3) {
                                int n8;
                                double d6 = 0.0;
                                for (n8 = n3; n8 < n5 + 1; ++n8) {
                                    if (d6 == Double.POSITIVE_INFINITY) {
                                        d6 = d2;
                                    }
                                    if (d6 == Double.NEGATIVE_INFINITY) {
                                        d6 = d3;
                                    }
                                    d6 += dArray5[n3][n8] * dArray[n8][n5];
                                }
                                double d7 = 0.0;
                                for (n8 = n3; n8 < n4 + 1; ++n8) {
                                    if (d7 == Double.POSITIVE_INFINITY) {
                                        d7 = d2;
                                    }
                                    if (d7 == Double.NEGATIVE_INFINITY) {
                                        d7 = d3;
                                    }
                                    d7 += dArray5[n3][n8] * dArray[n8][n4];
                                }
                                double[] dArray6 = dArray5[n5];
                                int n9 = n4;
                                dArray6[n9] = dArray6[n9] - d6 * d7 / dArray5[n5][n5];
                            }
                        }
                        if (dArray5[n5][n4] == Double.POSITIVE_INFINITY) {
                            dArray5[n5][n4] = d2;
                        }
                        if (dArray5[n5][n4] == Double.NEGATIVE_INFINITY) {
                            dArray5[n5][n4] = d3;
                        }
                        int n10 = n6;
                        dArray4[n10] = dArray4[n10] + dArray5[n5][n4] * dArray5[n5][n4];
                    }
                }
                if (dArray4[n6] != Double.POSITIVE_INFINITY) continue;
                dArray4[n6] = d2;
            }
        }
        double d8 = 0.0;
        for (n6 = 0; n6 < n2; ++n6) {
            d8 += Math.exp(-dArray4[n6] / 2.0);
        }
        return d8 / (double)n2;
    }

    public double[][] nextGWishart() {
        return GWishartLikelihood.nextGWishart(this.df, this.scaleMatrix, this.adjMatrix);
    }

    public static double[][] nextGWishart(double d, double[][] dArray, double[][] dArray2) {
        int n;
        int n2;
        int n3;
        System.out.println("nextGWishart");
        int n4 = dArray.length;
        double d2 = 1.7976931348623156E305;
        double d3 = 4.94E-321;
        double[] dArray3 = GWishartLikelihood.rowSums(dArray2);
        double[][] dArray4 = GWishartLikelihood.getTMatrix(dArray);
        double[][] dArray5 = GWishartLikelihood.getHMatrix(dArray4);
        double[][] dArray6 = new double[n4][n4];
        double[][] dArray7 = new double[n4][n4];
        double[][] dArray8 = new double[n4][n4];
        if (GWishartLikelihood.isDiagonal(dArray5)) {
            for (n3 = 0; n3 < n4; ++n3) {
                dArray6[n3][n3] = Math.sqrt(MathUtils.nextGamma((d + dArray3[n3]) * 0.5, 0.5));
            }
            for (n3 = 0; n3 < n4 - 1; ++n3) {
                for (n2 = n3 + 1; n2 < n4; ++n2) {
                    dArray6[n3][n2] = dArray2[n3][n2] == 1.0 ? MathUtils.nextGaussian() : 0.0;
                }
            }
            for (n3 = 0; n3 < n4 - 1; ++n3) {
                for (n2 = n3 + 1; n2 < n4; ++n2) {
                    if (dArray2[n3][n2] != 0.0) continue;
                    dArray6[n3][n2] = 0.0;
                    if (n3 > 0) {
                        double d4 = 0.0;
                        for (n = 0; n < n3; ++n) {
                            if (d4 == Double.POSITIVE_INFINITY) {
                                d4 = d2;
                            }
                            if (d4 == Double.NEGATIVE_INFINITY) {
                                d4 = d3;
                            }
                            d4 += dArray6[n][n3] * dArray6[n][n2];
                        }
                        if (d4 == Double.POSITIVE_INFINITY) {
                            d4 = d2;
                        }
                        if (d4 == Double.NEGATIVE_INFINITY) {
                            d4 = d3;
                        }
                        dArray6[n3][n2] = -d4 / dArray6[n3][n3];
                    }
                    if (dArray6[n3][n2] == Double.POSITIVE_INFINITY) {
                        dArray6[n3][n2] = d2;
                    }
                    if (dArray6[n3][n2] != Double.NEGATIVE_INFINITY) continue;
                    dArray6[n3][n2] = d3;
                }
            }
        } else {
            for (n3 = 0; n3 < n4; ++n3) {
                dArray6[n3][n3] = Math.sqrt(MathUtils.nextGamma((d + dArray3[n3]) * 0.5, 0.5));
            }
            for (n3 = 0; n3 < n4 - 1; ++n3) {
                for (n2 = n3 + 1; n2 < n4; ++n2) {
                    dArray6[n3][n2] = dArray2[n3][n2] == 1.0 ? MathUtils.nextGaussian() : 0.0;
                }
            }
            for (n3 = 0; n3 < n4 - 1; ++n3) {
                for (n2 = n3 + 1; n2 < n4; ++n2) {
                    if (dArray2[n3][n2] != 0.0) continue;
                    double d5 = 0.0;
                    for (n = n3; n < n2; ++n) {
                        if (d5 == Double.POSITIVE_INFINITY) {
                            d5 = d2;
                        }
                        if (d5 == Double.NEGATIVE_INFINITY) {
                            d5 = d3;
                        }
                        d5 += dArray6[n3][n] * dArray5[n][n2];
                    }
                    dArray6[n3][n2] = -d5;
                    if (n3 > 0) {
                        for (n = 0; n < n3; ++n) {
                            int n5;
                            double d6 = 0.0;
                            for (n5 = n; n5 < n3 + 1; ++n5) {
                                if (d6 == Double.POSITIVE_INFINITY) {
                                    d6 = d2;
                                }
                                if (d6 == Double.NEGATIVE_INFINITY) {
                                    d6 = d3;
                                }
                                d6 += dArray6[n][n5] * dArray5[n5][n3];
                            }
                            double d7 = 0.0;
                            for (n5 = n; n5 < n2 + 1; ++n5) {
                                if (d7 == Double.POSITIVE_INFINITY) {
                                    d7 = d2;
                                }
                                if (d7 == Double.NEGATIVE_INFINITY) {
                                    d7 = d3;
                                }
                                d7 += dArray6[n][n5] * dArray5[n5][n2];
                            }
                            double[] dArray9 = dArray6[n3];
                            int n6 = n2;
                            dArray9[n6] = dArray9[n6] - d6 * d7 / dArray6[n3][n3];
                        }
                    }
                    if (dArray6[n3][n2] == Double.POSITIVE_INFINITY) {
                        dArray6[n3][n2] = d2;
                    }
                    if (dArray6[n3][n2] != Double.NEGATIVE_INFINITY) continue;
                    dArray6[n3][n2] = d3;
                }
            }
        }
        for (n3 = 0; n3 < n4; ++n3) {
            for (n2 = 0; n2 < n4; ++n2) {
                for (n = 0; n < n4; ++n) {
                    double[] dArray10 = dArray7[n3];
                    int n7 = n2;
                    dArray10[n7] = dArray10[n7] + dArray6[n3][n] * dArray4[n][n2];
                }
            }
        }
        for (n3 = 0; n3 < n4; ++n3) {
            for (n2 = 0; n2 < n4; ++n2) {
                for (n = 0; n < n4; ++n) {
                    double[] dArray11 = dArray8[n3];
                    int n8 = n2;
                    dArray11[n8] = dArray11[n8] + dArray7[n][n3] * dArray7[n][n2];
                }
            }
        }
        return dArray8;
    }

    @Override
    public double logPdf(double[] dArray) {
        Matrix matrix = new Matrix(dArray, this.dim, this.dim);
        return GWishartLikelihood.logPdf(matrix, this.DMat, this.df, this.dim, this.logNormalizationConstant);
    }

    public static double logPdf(Matrix matrix, Matrix matrix2, double d, int n, double d2) {
        double d3 = 0.0;
        try {
            d3 = matrix.logDeterminant();
            if (Double.isInfinite(d3) || Double.isNaN(d3)) {
                return Double.NEGATIVE_INFINITY;
            }
            d3 *= 0.5;
            d3 *= d - 2.0;
            if (matrix2 != null) {
                Matrix matrix3 = matrix2.product(matrix);
                for (int i = 0; i < n; ++i) {
                    d3 -= 0.5 * matrix3.component(i, i);
                }
            }
        }
        catch (IllegalDimension illegalDimension) {
            illegalDimension.printStackTrace();
        }
        return d3 += d2;
    }

    public static void testBivariateMethod() {
        double d = 3.0;
        double[][] dArrayArray = new double[][]{{1.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 1.0}};
        Matrix matrix = new Matrix(dArrayArray);
        Matrix matrix2 = matrix.inverse();
        double[][] dArray = matrix2.toComponents();
        int n = dArrayArray.length;
        Parameter.Default default_ = new Parameter.Default(n * (n - 1) / 2, 1.0);
        Parameter[] parameterArray = new Parameter[n];
        for (int i = 0; i < n; ++i) {
            parameterArray[i] = new Parameter.Default(n, 0.0);
            parameterArray[i].setParameterValue(i, 1.0);
        }
        MatrixParameter matrixParameter = new MatrixParameter(null, parameterArray);
        for (int i = 0; i < n; ++i) {
            parameterArray[i] = new Parameter.Default(n, 0.002);
            parameterArray[i].setParameterValue(i, 0.05);
        }
        MatrixParameter matrixParameter2 = new MatrixParameter(null, parameterArray);
        GWishartLikelihood gWishartLikelihood = new GWishartLikelihood(matrixParameter, d, dArrayArray, default_, true);
        double[] dArray2 = new double[]{0.05, 0.002, 0.002, 0.002, 0.002, 0.002, 0.05, 0.002, 0.002, 0.002, 0.002, 0.002, 0.05, 0.002, 0.002, 0.002, 0.002, 0.002, 0.05, 0.002, 0.002, 0.002, 0.002, 0.002, 0.05};
        System.out.println("\nFast logPdf = " + gWishartLikelihood.logPdf(dArray2));
        System.out.println("\n logPdf = " + gWishartLikelihood.calculateLogLikelihood());
        System.out.println("log 1/IG(delta,D) = " + gWishartLikelihood.logNormalizationConstant);
        GWishartLikelihood gWishartLikelihood2 = new GWishartLikelihood(matrixParameter2, d, dArrayArray, default_, true);
        gWishartLikelihood2.getDistribution();
        System.out.println("\nFast logPdf = " + gWishartLikelihood2.logPdf(dArray2));
        System.out.println("\nlogPdf = " + gWishartLikelihood2.calculateLogLikelihood());
        System.out.println("log 1/IG(delta,D) = " + gWishartLikelihood2.logNormalizationConstant);
        System.out.println(gWishartLikelihood2.getDistribution().calculateLogLikelihood());
        double[] dArray3 = new double[]{0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
        double[][] dArray4 = GWishartLikelihood.nextGWishart(d, dArray, SymmetricMatrix.compoundSymmetricMatrix(new double[n], dArray3, n).toComponents());
        System.out.println("K=" + Arrays.deepToString((Object[])dArray4));
    }

    public static void main(String[] stringArray) {
        GWishartLikelihood.testBivariateMethod();
    }
}

