/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.distribution;

import dr.inference.distribution.ParametricMultivariateDistributionModel;
import dr.inference.model.AbstractModel;
import dr.inference.model.GradientProvider;
import dr.inference.model.HessianProvider;
import dr.inference.model.Likelihood;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.distributions.GaussianProcessRandomGenerator;
import dr.math.distributions.OldGaussianMarkovRandomField;

public class OldGaussianMarkovRandomFieldModel
extends AbstractModel
implements ParametricMultivariateDistributionModel,
GaussianProcessRandomGenerator,
GradientProvider,
HessianProvider {
    private final int dim;
    private final Parameter incrementPrecision;
    private final Parameter start;
    private OldGaussianMarkovRandomField distribution;
    private OldGaussianMarkovRandomField storedDistribution;
    private boolean distributionKnown;
    private boolean storedDistributionKnown;

    public OldGaussianMarkovRandomFieldModel(int n, Parameter parameter, Parameter parameter2) {
        super("multivariateNormalDistributionModel");
        this.dim = n;
        this.incrementPrecision = parameter;
        this.addVariable(parameter);
        this.start = parameter2;
        this.addVariable(parameter2);
        this.distribution = this.createNewDistribution();
        this.distributionKnown = true;
    }

    public Parameter getMeanParameter() {
        return null;
    }

    private void checkDistribution() {
        if (!this.distributionKnown) {
            this.distribution = this.createNewDistribution();
            this.distributionKnown = true;
        }
    }

    @Override
    public double logPdf(double[] dArray) {
        this.checkDistribution();
        return this.distribution.logPdf(dArray);
    }

    @Override
    public double[][] getScaleMatrix() {
        return this.distribution.getScaleMatrix();
    }

    @Override
    public double[] getMean() {
        return this.distribution.getMean();
    }

    @Override
    public String getType() {
        return this.distribution.getType();
    }

    @Override
    public void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    public Likelihood getLikelihood() {
        return null;
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.distributionKnown = false;
    }

    @Override
    protected void storeState() {
        this.storedDistribution = this.distribution;
        this.storedDistributionKnown = this.distributionKnown;
    }

    @Override
    protected void restoreState() {
        this.distributionKnown = this.storedDistributionKnown;
        this.distribution = this.storedDistribution;
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public int getDimension() {
        return this.dim;
    }

    @Override
    public double[][] getPrecisionMatrix() {
        return this.distribution.getPrecisionMatrix();
    }

    public Parameter getIncrementPrecision() {
        return this.incrementPrecision;
    }

    public Parameter getStart() {
        return this.start;
    }

    @Override
    public Variable<Double> getLocationVariable() {
        return null;
    }

    private OldGaussianMarkovRandomField createNewDistribution() {
        return new OldGaussianMarkovRandomField(this.getDimension(), this.incrementPrecision.getParameterValue(0), this.start.getParameterValue(0));
    }

    @Override
    public double[] nextRandom() {
        this.checkDistribution();
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double logPdf(Object object) {
        this.checkDistribution();
        return this.distribution.logPdf(object);
    }

    @Override
    public double[] getGradientLogDensity(Object object) {
        this.checkDistribution();
        return this.distribution.getGradientLogDensity(object);
    }

    @Override
    public double[] getDiagonalHessianLogDensity(Object object) {
        this.checkDistribution();
        return this.distribution.getDiagonalHessianLogDensity(object);
    }

    @Override
    public double[][] getHessianLogDensity(Object object) {
        this.checkDistribution();
        return this.distribution.getHessianLogDensity(object);
    }
}

