/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.mcmcmc;

import dr.inference.loggers.Logger;
import dr.inference.loggers.MCLogger;
import dr.inference.markovchain.MarkovChain;
import dr.inference.markovchain.MarkovChainListener;
import dr.inference.mcmc.MCMC;
import dr.inference.mcmc.MCMCCriterion;
import dr.inference.mcmc.MCMCOptions;
import dr.inference.mcmcmc.MCMCMCOptions;
import dr.inference.mcmcmc.MCMCMCRunner;
import dr.inference.mcmcmc.ParallelTempering;
import dr.inference.model.Likelihood;
import dr.inference.model.Model;
import dr.inference.operators.AdaptableMCMCOperator;
import dr.inference.operators.MCMCOperator;
import dr.inference.operators.OperatorAnalysisPrinter;
import dr.inference.operators.OperatorSchedule;
import dr.math.MathUtils;
import dr.util.NumberFormatter;
import dr.util.Timer;
import java.util.Collections;
import java.util.List;

public class MCMCMC
implements Runnable {
    public static final boolean DEBUG = false;
    private static final boolean DEBUG_IN_SERIES = false;
    private final MarkovChainListener chainListener = new MarkovChainListener(){

        @Override
        public synchronized void currentState(long l, MarkovChain markovChain, Model model) {
            MCLogger[] mCLoggerArray;
            MCMCMC.this.currentState = l;
            if (l % 1000L == 0L) {
                mCLoggerArray = new NumberFormatter(8);
                mCLoggerArray.setPadding(false);
                for (int i = 0; i < MCMCMC.this.chains.length; ++i) {
                    String string = i == MCMCMC.this.coldChain ? "[" + mCLoggerArray.format(MCMCMC.this.chains[i].getCurrentScore()) + "]" : mCLoggerArray.format(MCMCMC.this.chains[i].getCurrentScore());
                    string = string + " ";
                    System.out.print(mCLoggerArray.formatToFieldWidth(string, 12));
                }
                System.out.println();
            }
            for (MCLogger mCLogger : mCLoggerArray = MCMCMC.this.mcLoggers[MCMCMC.this.coldChain]) {
                mCLogger.log(l);
            }
        }

        @Override
        public synchronized void bestState(long l, MarkovChain markovChain, Model model) {
            MCMCMC.this.currentState = l;
        }

        @Override
        public synchronized void finished(long l, MarkovChain markovChain) {
        }
    };
    private final MCMCOptions mcmcOptions;
    private final MCMCMCOptions mcmcmcOptions;
    private boolean showOperatorAnalysis = true;
    private final Timer timer = new Timer();
    private long currentState = 0L;
    private final MarkovChain[] chains;
    private final MCLogger[][] mcLoggers;
    private final OperatorSchedule[] schedules;
    private int coldChain;
    private final ParallelTempering scheme;
    private static final boolean USE_PARALLEL_TEMPERING_SCHEME = false;

    public MCMCMC(MCMC[] mCMCArray, MCMCMCOptions mCMCMCOptions) {
        Object object;
        int n;
        this.mcmcmcOptions = mCMCMCOptions;
        if (mCMCMCOptions.getChainTemperatures()[0] != 1.0) {
            throw new RuntimeException("The first chain in the array should be cold (temperature = 1.0)");
        }
        this.coldChain = 0;
        this.mcmcOptions = mCMCArray[this.coldChain].getOptions();
        this.mcLoggers = new MCLogger[mCMCArray.length][];
        for (n = 0; n < mCMCArray.length; ++n) {
            object = mCMCArray[n].getLoggers();
            this.mcLoggers[n] = new MCLogger[((Logger[])object).length];
            for (int i = 0; i < ((Logger[])object).length; ++i) {
                this.mcLoggers[n][i] = (MCLogger)object[i];
            }
            if (this.mcLoggers[n] != null) continue;
            throw new RuntimeException("There are no loggers in the MCMC chains.");
        }
        this.schedules = new OperatorSchedule[mCMCArray.length];
        for (n = 0; n < this.schedules.length; ++n) {
            this.schedules[n] = mCMCArray[n].getOperatorSchedule();
        }
        this.chains = new MarkovChain[mCMCArray.length];
        this.chains[0] = mCMCArray[0].getMarkovChain();
        for (n = 1; n < this.chains.length; ++n) {
            this.chains[n] = mCMCArray[n].getMarkovChain();
            object = (MCMCCriterion)this.chains[n].getAcceptor();
            ((MCMCCriterion)object).setTemperature(mCMCMCOptions.getChainTemperatures()[n]);
            ((MCMCCriterion)object).setRank(n);
        }
        this.scheme = null;
    }

    @Override
    public void run() {
        int n;
        int n2;
        this.currentState = 0L;
        this.timer.start();
        MCLogger[] mCLoggerArray = this.mcLoggers[this.coldChain];
        List[] listArray = new List[mCLoggerArray.length];
        for (n2 = 0; n2 < mCLoggerArray.length; ++n2) {
            mCLoggerArray[n2].startLogging();
            listArray[n2] = mCLoggerArray[n2].getFormatters();
        }
        for (n2 = 0; n2 < this.mcLoggers.length; ++n2) {
            if (n2 == this.coldChain) continue;
            for (n = 0; n < this.mcLoggers[n2].length; ++n) {
                this.mcLoggers[n2][n].setFormatters(Collections.EMPTY_LIST);
            }
        }
        this.chains[this.coldChain].addMarkovChainListener(this.chainListener);
        MCMCMCRunner[] mCMCMCRunnerArray = new MCMCMCRunner[this.chains.length];
        for (n = 0; n < this.chains.length; ++n) {
            mCMCMCRunnerArray[n] = new MCMCMCRunner(this.chains[n], this.mcmcmcOptions.getSwapChainsEvery(), this.getChainLength(), false);
            mCMCMCRunnerArray[n].start();
        }
        while (this.chains[this.coldChain].getCurrentLength() < this.getChainLength()) {
            int n3;
            do {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                n = 1;
                for (n3 = 0; n3 < this.chains.length; ++n3) {
                    if (mCMCMCRunnerArray[n3].isChainDone()) continue;
                    n = 0;
                }
            } while (n == 0);
            if (this.chains[this.coldChain].getCurrentLength() >= this.getChainLength()) continue;
            n = this.coldChain;
            this.coldChain = this.swapChainTemperatures();
            if (this.coldChain != n) {
                this.chains[n].removeMarkovChainListener(this.chainListener);
                for (n3 = 0; n3 < this.mcLoggers[this.coldChain].length; ++n3) {
                    this.mcLoggers[this.coldChain][n3].setFormatters(listArray[n3]);
                }
                for (n3 = 0; n3 < this.mcLoggers[n].length; ++n3) {
                    this.mcLoggers[n][n3].setFormatters(Collections.EMPTY_LIST);
                }
                this.chains[this.coldChain].addMarkovChainListener(this.chainListener);
            }
            for (n3 = 0; n3 < this.chains.length; ++n3) {
                mCMCMCRunnerArray[n3].continueChain();
            }
        }
        this.finish();
        this.timer.stop();
    }

    private void runChains(long l, boolean bl) {
        int n;
        Thread[] threadArray = new Thread[this.chains.length];
        for (n = 0; n < this.chains.length; ++n) {
            threadArray[n] = new MCMCMCRunner(this.chains[n], l, l, false);
            threadArray[n].start();
        }
        for (n = 0; n < this.chains.length; ++n) {
            while (threadArray[n].isAlive()) {
                try {
                    threadArray[n].join();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private int swapChainTemperatures() {
        boolean bl;
        int n = this.coldChain;
        int n2 = MathUtils.nextInt(this.chains.length);
        int n3 = MathUtils.nextInt(this.chains.length);
        while (n2 == n3) {
            n3 = MathUtils.nextInt(this.chains.length);
        }
        double d = this.chains[n2].getCurrentScore();
        MCMCCriterion mCMCCriterion = (MCMCCriterion)this.chains[n2].getAcceptor();
        double d2 = mCMCCriterion.getTemperature();
        double d3 = this.chains[n3].getCurrentScore();
        MCMCCriterion mCMCCriterion2 = (MCMCCriterion)this.chains[n3].getAcceptor();
        double d4 = mCMCCriterion2.getTemperature();
        double d5 = (d3 - d) * d2 + (d - d3) * d4;
        boolean bl2 = bl = Math.log(MathUtils.nextDouble()) < d5;
        if (bl) {
            mCMCCriterion.setTemperature(d4);
            mCMCCriterion2.setTemperature(d2);
            OperatorSchedule operatorSchedule = this.schedules[n2];
            OperatorSchedule operatorSchedule2 = this.schedules[n3];
            for (int i = 0; i < operatorSchedule.getOperatorCount(); ++i) {
                MCMCOperator mCMCOperator = operatorSchedule.getOperator(i);
                MCMCOperator mCMCOperator2 = operatorSchedule2.getOperator(i);
                long l = mCMCOperator.getAcceptCount();
                mCMCOperator.setAcceptCount(mCMCOperator2.getAcceptCount());
                mCMCOperator2.setAcceptCount(l);
                l = mCMCOperator.getRejectCount();
                mCMCOperator.setRejectCount(mCMCOperator2.getRejectCount());
                mCMCOperator2.setRejectCount(l);
                double d6 = mCMCOperator.getSumDeviation();
                mCMCOperator.setSumDeviation(mCMCOperator2.getSumDeviation());
                mCMCOperator2.setSumDeviation(d6);
                if (!(mCMCOperator instanceof AdaptableMCMCOperator)) continue;
                d6 = ((AdaptableMCMCOperator)mCMCOperator).getAdaptableParameter();
                ((AdaptableMCMCOperator)mCMCOperator).setAdaptableParameter(((AdaptableMCMCOperator)mCMCOperator2).getAdaptableParameter());
                ((AdaptableMCMCOperator)mCMCOperator2).setAdaptableParameter(d6);
            }
            if (n2 == this.coldChain) {
                n = n3;
            } else if (n3 == this.coldChain) {
                n = n2;
            }
        }
        return n;
    }

    private void resetChains() {
        for (MarkovChain markovChain : this.chains) {
            markovChain.reset();
        }
    }

    private void finish() {
        MCLogger[] mCLoggerArray;
        NumberFormatter numberFormatter = new NumberFormatter(8);
        for (MCLogger mCLogger : mCLoggerArray = this.mcLoggers[this.coldChain]) {
            mCLogger.log(this.currentState);
            mCLogger.stopLogging();
        }
        System.out.println();
        System.out.println("Time taken: " + this.timer.toString());
        if (this.showOperatorAnalysis) {
            System.out.println();
            System.out.println("Operator analysis");
            System.out.println(numberFormatter.formatToFieldWidth("Operator", 30) + numberFormatter.formatToFieldWidth("", 8) + numberFormatter.formatToFieldWidth("Pr(accept)", 11) + " Performance suggestion");
            OperatorAnalysisPrinter.showOperatorAnalysis(System.out, this.schedules[this.coldChain], this.mcmcOptions.useAdaptation());
            System.out.println();
        }
    }

    public int getColdChain() {
        return this.coldChain;
    }

    public Likelihood getLikelihood() {
        return this.chains[this.coldChain].getLikelihood();
    }

    public Timer getTimer() {
        return this.timer;
    }

    public final long getChainLength() {
        return this.mcmcOptions.getChainLength();
    }

    public final long getCurrentState() {
        return this.currentState;
    }

    public final double getProgress() {
        return (double)this.currentState / (double)this.mcmcOptions.getChainLength();
    }

    public void pleaseStop() {
        for (MarkovChain markovChain : this.chains) {
            markovChain.pleaseStop();
        }
    }

    public void setShowOperatorAnalysis(boolean bl) {
        this.showOperatorAnalysis = bl;
    }
}

