/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.CompoundParameter;
import dr.inference.model.MatrixParameterInterface;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.inference.model.VariableListener;
import java.util.ArrayList;

public class MaskedMatrixParameter
extends CompoundParameter
implements MatrixParameterInterface,
VariableListener {
    private final MatrixParameterInterface matrix;
    private final Parameter mask;
    private ArrayList<Integer> rows = new ArrayList();

    public MaskedMatrixParameter(MatrixParameterInterface matrixParameterInterface, Parameter parameter) {
        super(matrixParameterInterface.getParameterName() + ".mask");
        this.matrix = matrixParameterInterface;
        this.mask = parameter;
        this.addParameter(matrixParameterInterface);
        this.addParameter(parameter);
        this.rows = this.makeRowsFromMask();
    }

    @Override
    public void variableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        if (variable == this.mask) {
            int n2;
            ArrayList<Integer> arrayList = this.rows;
            this.rows = this.makeRowsFromMask();
            int n3 = this.rows.size();
            changeType = n3 == (n2 = arrayList.size()) ? Variable.ChangeType.ALL_VALUES_CHANGED : (n3 < n2 ? Variable.ChangeType.REMOVED : Variable.ChangeType.ADDED);
            n = -1;
        }
        super.variableChangedEvent(variable, n, changeType);
    }

    private ArrayList<Integer> makeRowsFromMask() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < this.mask.getDimension(); ++i) {
            if (this.mask.getParameterValue(i) != 1.0) continue;
            arrayList.add(i);
        }
        return arrayList;
    }

    @Override
    public double getParameterValue(int n, int n2) {
        return this.matrix.getParameterValue(this.rows.get(n), n2);
    }

    @Override
    public void setParameterValue(int n, int n2, double d) {
        this.matrix.setParameterValue(this.rows.get(n), n2, d);
    }

    @Override
    public void setParameterValueQuietly(int n, int n2, double d) {
        this.matrix.setParameterValueQuietly(this.rows.get(n), n2, d);
    }

    @Override
    public void setParameterValueNotifyChangedAll(int n, int n2, double d) {
        this.matrix.setParameterValueNotifyChangedAll(this.rows.get(n), n2, d);
    }

    @Override
    public double[] getColumnValues(int n) {
        double[] dArray = new double[this.rows.size()];
        for (int i = 0; i < this.rows.size(); ++i) {
            dArray[i] = this.matrix.getParameterValue(this.rows.get(i), n);
        }
        return dArray;
    }

    @Override
    public double[][] getParameterAsMatrix() {
        double[][] dArray = new double[this.matrix.getColumnDimension()][this.rows.size()];
        for (int i = 0; i < this.matrix.getColumnDimension(); ++i) {
            for (int j = 0; j < this.rows.size(); ++j) {
                dArray[i][j] = this.getParameterValue(i, j);
            }
        }
        return dArray;
    }

    @Override
    public int getColumnDimension() {
        return this.matrix.getColumnDimension();
    }

    @Override
    public int getRowDimension() {
        return this.rows.size();
    }

    @Override
    public int getUniqueParameterCount() {
        return this.matrix.getUniqueParameterCount();
    }

    @Override
    public Parameter getUniqueParameter(int n) {
        return this.matrix.getUniqueParameter(n);
    }

    @Override
    public void copyParameterValues(double[] dArray, int n) {
        throw new RuntimeException("not yet implemented");
    }

    @Override
    public void setAllParameterValuesQuietly(double[] dArray, int n) {
        throw new RuntimeException("not yet implemented");
    }

    @Override
    public String toSymmetricString() {
        throw new RuntimeException("not yet implemented");
    }

    @Override
    public boolean isConstrainedSymmetric() {
        return false;
    }
}

