/*
 * Decompiled with CFR 0.152.
 */
package dr.math;

import dr.math.BigDecimalUtils;
import dr.math.LogTricks;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Arrays;

public interface Polynomial
extends Cloneable {
    public int getDegree();

    public Polynomial multiply(Polynomial var1);

    public Polynomial integrate();

    public double evaluate(double var1);

    public double logEvaluate(double var1);

    public double logEvaluateHorner(double var1);

    public void expand(double var1);

    public Polynomial integrateWithLowerBound(double var1);

    public double getCoefficient(int var1);

    public String getCoefficientString(int var1);

    public void setCoefficient(int var1, double var2);

    public Polynomial getPolynomial();

    public Polynomial copy();

    public static enum Type {
        DOUBLE,
        APDOUBLE,
        LOG_DOUBLE,
        BIG_DOUBLE;

    }

    public static class Double
    extends Abstract {
        double[] coefficient;

        public Double(double[] dArray) {
            this.coefficient = dArray;
        }

        @Override
        public Double copy() {
            return new Double((double[])this.coefficient.clone());
        }

        public Double(Polynomial polynomial) {
            this.coefficient = new double[polynomial.getDegree() + 1];
            for (int i = 0; i <= polynomial.getDegree(); ++i) {
                this.coefficient[i] = polynomial.getCoefficient(i);
            }
        }

        @Override
        public void expand(double d) {
            int n = this.getDegree();
            for (int i = 0; i <= n; ++i) {
                this.coefficient[i] = d * this.coefficient[i];
            }
        }

        @Override
        public String getCoefficientString(int n) {
            return String.format("%3.2e", this.getCoefficient(n));
        }

        @Override
        public int getDegree() {
            return this.coefficient.length - 1;
        }

        @Override
        public double getCoefficient(int n) {
            return this.coefficient[n];
        }

        @Override
        public double logEvaluate(double d) {
            return Math.log(this.evaluate(d));
        }

        public double logEvaluateQuick(double d, int n) {
            return Math.log(this.evaluateQuick(d, n));
        }

        @Override
        public double logEvaluateHorner(double d) {
            int n = this.getDegree();
            double d2 = Math.log(d);
            boolean bl = this.coefficient[n] > 0.0;
            double d3 = bl ? Math.log(this.coefficient[n]) : Math.log(-this.coefficient[n]);
            for (int i = n - 1; i >= 0; --i) {
                d3 += d2;
                boolean bl2 = this.coefficient[i] > 0.0;
                double d4 = bl2 ? Math.log(this.coefficient[i]) : Math.log(-this.coefficient[i]);
                if (!(bl2 ^ bl)) {
                    d3 = LogTricks.logSum(d3, d4);
                    continue;
                }
                if (d3 > d4) {
                    d3 = LogTricks.logDiff(d3, d4);
                    continue;
                }
                d3 = LogTricks.logDiff(d4, d3);
                bl = !bl;
            }
            if (!bl) {
                return java.lang.Double.NaN;
            }
            return d3;
        }

        @Override
        public Double multiply(Polynomial polynomial) {
            double[] dArray = new double[this.getDegree() + polynomial.getDegree() + 1];
            for (int i = 0; i <= this.getDegree(); ++i) {
                for (int j = 0; j <= polynomial.getDegree(); ++j) {
                    int n = i + j;
                    dArray[n] = dArray[n] + this.coefficient[i] * polynomial.getCoefficient(j);
                }
            }
            return new Double(dArray);
        }

        @Override
        public Double integrate() {
            double[] dArray = new double[this.getDegree() + 2];
            for (int i = 0; i <= this.getDegree(); ++i) {
                dArray[i + 1] = this.coefficient[i] / (double)(i + 1);
            }
            return new Double(dArray);
        }

        public double evaluateHorners(double d) {
            int n = this.getDegree();
            double d2 = this.coefficient[n];
            for (int i = n - 1; i >= 0; --i) {
                d2 = d2 * d + this.coefficient[i];
            }
            return d2;
        }

        public double evaluateQuick(double d, int n) {
            int n2 = this.getDegree();
            double d2 = Math.pow(d, n2);
            double d3 = d2 * this.coefficient[n2];
            for (int i = n - 1; i > 0; --i) {
                d3 += (d2 /= d) * this.coefficient[--n2];
            }
            return d3;
        }

        @Override
        public double evaluate(double d) {
            double d2 = 0.0;
            double d3 = 1.0;
            for (int i = 0; i <= this.getDegree(); ++i) {
                d2 += d3 * this.coefficient[i];
                d3 *= d;
            }
            return d2;
        }

        @Override
        public Polynomial integrateWithLowerBound(double d) {
            Double double_ = this.integrate();
            double_.coefficient[0] = -double_.evaluate(d);
            return double_;
        }

        @Override
        public void setCoefficient(int n, double d) {
            this.coefficient[n] = d;
        }
    }

    public static class BigDouble
    extends Abstract {
        private static MathContext precision = new MathContext(1000);
        BigDecimal[] coefficient;

        public BigDouble(double[] dArray) {
            this.coefficient = new BigDecimal[dArray.length];
            for (int i = 0; i < dArray.length; ++i) {
                this.coefficient[i] = new BigDecimal(dArray[i]);
            }
        }

        @Override
        public BigDouble copy() {
            return new BigDouble((BigDecimal[])this.coefficient.clone());
        }

        @Override
        public String getCoefficientString(int n) {
            return this.coefficient[n].toString();
        }

        @Override
        public void expand(double d) {
            throw new RuntimeException("Not yet implement: Polynomial.BigDouble.expand()");
        }

        public BigDouble(BigDecimal[] bigDecimalArray) {
            this.coefficient = bigDecimalArray;
        }

        @Override
        public int getDegree() {
            return this.coefficient.length - 1;
        }

        @Override
        public BigDouble multiply(Polynomial polynomial) {
            int n;
            if (!(polynomial.getPolynomial() instanceof BigDouble)) {
                throw new RuntimeException("Incompatiable polynomial types");
            }
            BigDouble bigDouble = (BigDouble)polynomial.getPolynomial();
            BigDecimal[] bigDecimalArray = new BigDecimal[this.getDegree() + bigDouble.getDegree() + 1];
            for (n = 0; n < bigDecimalArray.length; ++n) {
                bigDecimalArray[n] = new BigDecimal(0.0);
            }
            for (n = 0; n <= this.getDegree(); ++n) {
                for (int i = 0; i <= bigDouble.getDegree(); ++i) {
                    bigDecimalArray[n + i] = bigDecimalArray[n + i].add(this.coefficient[n].multiply(bigDouble.coefficient[i]));
                }
            }
            return new BigDouble(bigDecimalArray);
        }

        @Override
        public BigDouble integrate() {
            BigDecimal[] bigDecimalArray = new BigDecimal[this.getDegree() + 2];
            for (int i = 0; i <= this.getDegree(); ++i) {
                bigDecimalArray[i + 1] = this.coefficient[i].divide(new BigDecimal(i + 1), precision);
            }
            bigDecimalArray[0] = new BigDecimal(0.0);
            return new BigDouble(bigDecimalArray);
        }

        @Override
        public double evaluate(double d) {
            return this.evaluateBigDecimal(new BigDecimal(d)).doubleValue();
        }

        @Override
        public double logEvaluate(double d) {
            return BigDecimalUtils.ln(this.evaluateBigDecimal(new BigDecimal(d)), 10).doubleValue();
        }

        @Override
        public double logEvaluateHorner(double d) {
            return this.logEvaluate(d);
        }

        protected BigDecimal evaluateBigDecimal(BigDecimal bigDecimal) {
            BigDecimal bigDecimal2 = new BigDecimal(0.0);
            BigDecimal bigDecimal3 = new BigDecimal(1.0);
            for (int i = 0; i <= this.getDegree(); ++i) {
                bigDecimal2 = bigDecimal2.add(this.coefficient[i].multiply(bigDecimal3));
                bigDecimal3 = bigDecimal3.multiply(bigDecimal);
            }
            return bigDecimal2;
        }

        @Override
        public double getCoefficient(int n) {
            return this.coefficient[n].doubleValue();
        }

        @Override
        public void setCoefficient(int n, double d) {
            this.coefficient[n] = new BigDecimal(d);
        }

        @Override
        public Polynomial integrateWithLowerBound(double d) {
            BigDouble bigDouble = this.integrate();
            BigDecimal bigDecimal = bigDouble.evaluateBigDecimal(new BigDecimal(d));
            bigDouble.coefficient[0] = bigDecimal.multiply(new BigDecimal(-1.0));
            return bigDouble;
        }

        public void setCoefficient(int n, BigDecimal bigDecimal) {
            this.coefficient[n] = bigDecimal;
        }
    }

    public static class LogDouble
    extends Abstract {
        double[] logCoefficient;
        boolean[] positiveCoefficient;

        public LogDouble(double[] dArray) {
            this.logCoefficient = new double[dArray.length];
            this.positiveCoefficient = new boolean[dArray.length];
            for (int i = 0; i < dArray.length; ++i) {
                if (dArray[i] < 0.0) {
                    this.logCoefficient[i] = Math.log(-dArray[i]);
                    this.positiveCoefficient[i] = false;
                    continue;
                }
                this.logCoefficient[i] = Math.log(dArray[i]);
                this.positiveCoefficient[i] = true;
            }
        }

        public double getLogCoefficient(int n) {
            return this.logCoefficient[n];
        }

        @Override
        public void expand(double d) {
            int n = this.getDegree();
            for (int i = 0; i <= n; ++i) {
                this.logCoefficient[i] = d + this.logCoefficient[i];
            }
        }

        @Override
        public String getCoefficientString(int n) {
            return String.format("%3.2e", this.getCoefficient(n));
        }

        public LogDouble(double[] dArray, boolean[] blArray) {
            this.logCoefficient = dArray;
            if (blArray != null) {
                this.positiveCoefficient = blArray;
            } else {
                this.positiveCoefficient = new boolean[dArray.length];
                Arrays.fill(this.positiveCoefficient, true);
            }
        }

        @Override
        public LogDouble copy() {
            return new LogDouble((double[])this.logCoefficient.clone(), (boolean[])this.positiveCoefficient.clone());
        }

        @Override
        public int getDegree() {
            return this.logCoefficient.length - 1;
        }

        @Override
        public LogDouble multiply(Polynomial polynomial) {
            if (!(polynomial.getPolynomial() instanceof LogDouble)) {
                throw new RuntimeException("yuck!");
            }
            LogDouble logDouble = (LogDouble)polynomial.getPolynomial();
            int n = this.getDegree();
            int n2 = logDouble.getDegree();
            double[] dArray = new double[n + n2 + 1];
            boolean[] blArray = new boolean[n + n2 + 1];
            Arrays.fill(dArray, java.lang.Double.NEGATIVE_INFINITY);
            Arrays.fill(blArray, true);
            for (int i = 0; i <= n; ++i) {
                for (int j = 0; j <= n2; ++j) {
                    boolean bl;
                    double d = this.logCoefficient[i] + logDouble.logCoefficient[j];
                    int n3 = i + j;
                    boolean bl2 = bl = !(this.positiveCoefficient[i] ^ logDouble.positiveCoefficient[j]);
                    if (dArray[n3] == java.lang.Double.NEGATIVE_INFINITY) {
                        dArray[n3] = d;
                        blArray[n3] = bl;
                        continue;
                    }
                    if (d == 0.0) continue;
                    if (blArray[n3] ^ bl) {
                        if (dArray[n3] > d) {
                            dArray[n3] = LogTricks.logDiff(dArray[n3], d);
                            continue;
                        }
                        dArray[n3] = LogTricks.logDiff(d, dArray[n3]);
                        blArray[n3] = !blArray[n3];
                        continue;
                    }
                    dArray[n3] = LogTricks.logSum(dArray[n3], d);
                }
            }
            return new LogDouble(dArray, blArray);
        }

        @Override
        public LogDouble integrate() {
            int n = this.getDegree();
            double[] dArray = new double[n + 2];
            boolean[] blArray = new boolean[n + 2];
            for (int i = 0; i <= n; ++i) {
                dArray[i + 1] = this.logCoefficient[i] - Math.log(i + 1);
                blArray[i + 1] = this.positiveCoefficient[i];
            }
            dArray[0] = java.lang.Double.NEGATIVE_INFINITY;
            blArray[0] = true;
            return new LogDouble(dArray, blArray);
        }

        @Override
        public double evaluate(double d) {
            SignedLogDouble signedLogDouble = this.signedLogEvaluate(d);
            double d2 = Math.exp(signedLogDouble.value);
            if (!signedLogDouble.positive) {
                d2 = -d2;
            }
            return d2;
        }

        public double evaluateAsReal(double d) {
            double d2 = 0.0;
            double d3 = 1.0;
            for (int i = 0; i <= this.getDegree(); ++i) {
                d2 += d3 * this.getCoefficient(i);
                d3 *= d;
            }
            return d2;
        }

        @Override
        public double logEvaluate(double d) {
            if (d < 0.0) {
                throw new RuntimeException("Negative arguments not yet implemented in Polynomial.LogDouble");
            }
            SignedLogDouble signedLogDouble = this.signedLogEvaluate(d);
            if (signedLogDouble.positive) {
                return signedLogDouble.value;
            }
            return java.lang.Double.NaN;
        }

        @Override
        public double logEvaluateHorner(double d) {
            if (d < 0.0) {
                throw new RuntimeException("Negative arguments not yet implemented in Polynomial.LogDouble");
            }
            SignedLogDouble signedLogDouble = this.signedLogEvaluateHorners(d);
            if (signedLogDouble.positive) {
                return signedLogDouble.value;
            }
            return java.lang.Double.NaN;
        }

        public SignedLogDouble signedLogEvaluateHorners(double d) {
            double d2 = Math.log(d);
            int n = this.getDegree();
            double d3 = this.logCoefficient[n];
            boolean bl = this.positiveCoefficient[n];
            for (int i = n - 1; i >= 0; --i) {
                d3 += d2;
                if (!(this.positiveCoefficient[i] ^ bl)) {
                    d3 = LogTricks.logSum(d3, this.logCoefficient[i]);
                    continue;
                }
                if (d3 > this.logCoefficient[i]) {
                    d3 = LogTricks.logDiff(d3, this.logCoefficient[i]);
                    continue;
                }
                d3 = LogTricks.logDiff(this.logCoefficient[i], d3);
                bl = !bl;
            }
            return new SignedLogDouble(d3, bl);
        }

        private SignedLogDouble signedLogEvaluate(double d) {
            double d2 = Math.log(d);
            int n = this.getDegree();
            double d3 = this.logCoefficient[0];
            boolean bl = this.positiveCoefficient[0];
            for (int i = 1; i <= n; ++i) {
                double d4 = (double)i * d2 + this.logCoefficient[i];
                if (!(this.positiveCoefficient[i] ^ bl)) {
                    d3 = LogTricks.logSum(d3, d4);
                    continue;
                }
                if (d3 > d4) {
                    d3 = LogTricks.logDiff(d3, d4);
                    continue;
                }
                d3 = LogTricks.logDiff(d4, d3);
                bl = !bl;
            }
            return new SignedLogDouble(d3, bl);
        }

        @Override
        public double getCoefficient(int n) {
            double d = Math.exp(this.logCoefficient[n]);
            if (!this.positiveCoefficient[n]) {
                d *= -1.0;
            }
            return d;
        }

        @Override
        public void setCoefficient(int n, double d) {
            if (d < 0.0) {
                this.positiveCoefficient[n] = false;
                d = -d;
            } else {
                this.positiveCoefficient[n] = true;
            }
            this.logCoefficient[n] = Math.log(d);
        }

        @Override
        public Polynomial integrateWithLowerBound(double d) {
            LogDouble logDouble = this.integrate();
            SignedLogDouble signedLogDouble = logDouble.signedLogEvaluate(d);
            logDouble.logCoefficient[0] = signedLogDouble.value;
            logDouble.positiveCoefficient[0] = !signedLogDouble.positive;
            return logDouble;
        }

        class SignedLogDouble {
            double value;
            boolean positive;

            SignedLogDouble(double d, boolean bl) {
                this.value = d;
                this.positive = bl;
            }
        }
    }

    public static abstract class Abstract
    implements Polynomial {
        protected static final String FORMAT = "%3.2e";
        private static final String X = " x^";

        @Override
        public abstract int getDegree();

        @Override
        public abstract Polynomial multiply(Polynomial var1);

        @Override
        public abstract Polynomial integrate();

        @Override
        public abstract double evaluate(double var1);

        @Override
        public abstract double getCoefficient(int var1);

        @Override
        public abstract void setCoefficient(int var1, double var2);

        @Override
        public abstract Polynomial integrateWithLowerBound(double var1);

        @Override
        public Polynomial getPolynomial() {
            return this;
        }

        @Override
        public abstract double logEvaluate(double var1);

        @Override
        public abstract double logEvaluateHorner(double var1);

        @Override
        public abstract void expand(double var1);

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = this.getDegree(); i >= 0; --i) {
                stringBuffer.append(this.getCoefficientString(i));
                stringBuffer.append(X);
                stringBuffer.append(i);
                if (i <= 0) continue;
                stringBuffer.append(" + ");
            }
            return stringBuffer.toString();
        }

        @Override
        public abstract String getCoefficientString(int var1);
    }
}

