% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_functions.R
\name{fileFinder}
\alias{fileFinder}
\title{Finds files within a directory}
\usage{
fileFinder(path, fileName)
}
\arguments{
\item{path}{A directory as character. The directory to recursively search.}

\item{fileName}{A character/regex string. The file name to find.}
}
\value{
Returns a directory to the most-recent file that matches the provide file. Using regex
can greatly improve specificity.
The function will also write into the console the file that it has found - it is worthwhile to
check that this is the correct file to avoid complications down the line
}
\description{
A function which can be used to find files within a user-defined directory based on a
user-provided character string.
}
\examples{
\donttest{
# load dplyr
library(dplyr)

 # Make the RootPath to the tempdir for this example
  RootPath <- tempdir()
  
 # Load the example data
 data("beesRaw", package = "BeeBDC")

# Save and example dataset to the temp dir
  readr::write_csv(beesRaw, file = paste0(RootPath, "/beesRaw.csv"))

 # Now go find it!
fileFinder(path = RootPath, fileName = "beesRaw")
# more specifically the .csv version
fileFinder(path = RootPath, fileName = "beesRaw.csv")
}
}
