// Generated by rstantools.  Do not edit by hand.

/*
    BeeGUTS is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    BeeGUTS is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with BeeGUTS.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.32.2
#include <stan/model/model_header.hpp>
namespace model_GUTS_hb_only_namespace {
using stan::model::model_base_crtp;
using namespace stan::math;
stan::math::profile_map profiles__;
static constexpr std::array<const char*, 97> locations_array__ =
  {" (found before start of program)",
  " (in 'string', line 106, column 2 to column 13)",
  " (in 'string', line 109, column 2 to column 16)",
  " (in 'string', line 110, column 2 to column 22)",
  " (in 'string', line 111, column 2 to column 50)",
  " (in 'string', line 112, column 2 to column 62)",
  " (in 'string', line 125, column 2 to column 35)",
  " (in 'string', line 126, column 2 to column 35)",
  " (in 'string', line 127, column 2 to column 40)",
  " (in 'string', line 128, column 2 to column 30)",
  " (in 'string', line 113, column 2 to column 48)",
  " (in 'string', line 115, column 4 to column 24)",
  " (in 'string', line 116, column 4 to column 45)",
  " (in 'string', line 117, column 4 to column 87)",
  " (in 'string', line 114, column 25 to line 118, column 3)",
  " (in 'string', line 114, column 2 to line 118, column 3)",
  " (in 'string', line 131, column 5 to column 69)",
  " (in 'string', line 132, column 5 to column 66)",
  " (in 'string', line 133, column 5 to column 78)",
  " (in 'string', line 134, column 5 to column 115)",
  " (in 'string', line 130, column 26 to line 135, column 4)",
  " (in 'string', line 130, column 3 to line 135, column 4)",
  " (in 'string', line 121, column 2 to column 38)",
  " (in 'string', line 122, column 2 to column 109)",
  " (in 'string', line 89, column 0 to column 24)",
  " (in 'string', line 91, column 0 to column 20)",
  " (in 'string', line 93, column 0 to column 25)",
  " (in 'string', line 94, column 6 to column 17)",
  " (in 'string', line 94, column 0 to column 29)",
  " (in 'string', line 95, column 6 to column 17)",
  " (in 'string', line 95, column 0 to column 29)",
  " (in 'string', line 96, column 6 to column 17)",
  " (in 'string', line 96, column 0 to column 31)",
  " (in 'string', line 97, column 0 to column 20)",
  " (in 'string', line 98, column 0 to column 20)",
  " (in 'string', line 100, column 0 to column 18)",
  " (in 'string', line 101, column 0 to column 16)",
  " (in 'string', line 111, column 27 to column 38)",
  " (in 'string', line 112, column 27 to column 38)",
  " (in 'string', line 125, column 8 to column 19)",
  " (in 'string', line 126, column 8 to column 19)",
  " (in 'string', line 127, column 8 to column 19)",
  " (in 'string', line 128, column 9 to column 20)",
  " (in 'string', line 26, column 6 to column 14)",
  " (in 'string', line 27, column 6 to column 12)",
  " (in 'string', line 28, column 6 to column 19)",
  " (in 'string', line 29, column 6 to column 16)",
  " (in 'string', line 30, column 6 to column 17)",
  " (in 'string', line 31, column 6 to column 19)",
  " (in 'string', line 32, column 6 to column 20)",
  " (in 'string', line 33, column 6 to column 15)",
  " (in 'string', line 35, column 6 to column 31)",
  " (in 'string', line 37, column 17 to column 27)",
  " (in 'string', line 37, column 6 to column 27)",
  " (in 'string', line 39, column 6 to column 28)",
  " (in 'string', line 40, column 6 to column 20)",
  " (in 'string', line 42, column 6 to column 25)",
  " (in 'string', line 43, column 6 to column 36)",
  " (in 'string', line 44, column 6 to column 36)",
  " (in 'string', line 46, column 21 to column 40)",
  " (in 'string', line 46, column 6 to column 40)",
  " (in 'string', line 47, column 21 to column 33)",
  " (in 'string', line 47, column 6 to column 33)",
  " (in 'string', line 48, column 21 to column 31)",
  " (in 'string', line 48, column 6 to column 31)",
  " (in 'string', line 50, column 6 to column 15)",
  " (in 'string', line 52, column 8 to column 20)",
  " (in 'string', line 53, column 8 to column 17)",
  " (in 'string', line 55, column 8 to column 47)",
  " (in 'string', line 56, column 8 to column 34)",
  " (in 'string', line 57, column 22 to column 40)",
  " (in 'string', line 57, column 8 to column 40)",
  " (in 'string', line 58, column 31 to column 43)",
  " (in 'string', line 58, column 44 to column 64)",
  " (in 'string', line 58, column 29 to column 66)",
  " (in 'string', line 58, column 8 to column 66)",
  " (in 'string', line 59, column 31 to column 43)",
  " (in 'string', line 59, column 44 to column 64)",
  " (in 'string', line 59, column 29 to column 66)",
  " (in 'string', line 59, column 8 to column 66)",
  " (in 'string', line 60, column 8 to column 24)",
  " (in 'string', line 51, column 61 to line 61, column 7)",
  " (in 'string', line 51, column 6 to line 61, column 7)",
  " (in 'string', line 62, column 27 to column 74)",
  " (in 'string', line 62, column 6 to column 74)",
  " (in 'string', line 63, column 6 to column 23)",
  " (in 'string', line 25, column 60 to line 64, column 2)",
  " (in 'string', line 67, column 4 to column 23)",
  " (in 'string', line 69, column 4 to column 90)",
  " (in 'string', line 71, column 4 to column 26)",
  " (in 'string', line 66, column 86 to line 72, column 1)",
  " (in 'string', line 76, column 6 to line 77, column 58)",
  " (in 'string', line 75, column 56 to line 78, column 1)",
  " (in 'string', line 81, column 2 to column 53)",
  " (in 'string', line 80, column 56 to line 82, column 1)",
  " (in 'string', line 85, column 2 to column 52)",
  " (in 'string', line 84, column 57 to line 86, column 1)"};
template <typename T0__, typename T1__,
          stan::require_all_t<stan::is_stan_scalar<T0__>,
                              stan::is_col_vector<T1__>,
                              stan::is_vt_not_complex<T1__>>* = nullptr>
int
find_interval_elem(const T0__& x, const T1__& sorted_arg__, const int&
                   start_ind, std::ostream* pstream__);
template <typename T0__, typename T1__, typename T2__, typename T3__,
          typename T4__,
          stan::require_all_t<stan::is_stan_scalar<T0__>,
                              stan::is_stan_scalar<T1__>,
                              stan::is_stan_scalar<T2__>,
                              stan::is_stan_scalar<T3__>,
                              stan::is_stan_scalar<T4__>>* = nullptr>
stan::promote_args_t<T0__, T1__, T2__, T3__, T4__>
linearInterp(const T0__& t_x, const T1__& t_before, const T2__& t_after,
             const T3__& y_before, const T4__& y_after, std::ostream*
             pstream__);
template <bool propto__, typename T0__, typename T1__, typename T2__,
          stan::require_all_t<stan::is_stan_scalar<T0__>,
                              stan::is_stan_scalar<T1__>,
                              stan::is_stan_scalar<T2__>>* = nullptr>
stan::promote_args_t<T0__, T1__, T2__>
loglogistic_2_lpdf(const T0__& y_hat, const T1__& mw, const T2__& beta,
                   std::ostream* pstream__);
template <typename T0__, typename T1__, typename T2__,
          stan::require_all_t<stan::is_stan_scalar<T0__>,
                              stan::is_stan_scalar<T1__>,
                              stan::is_stan_scalar<T2__>>* = nullptr>
stan::promote_args_t<T0__, T1__, T2__>
loglogistic_2_lcdf(const T0__& y_hat, const T1__& mw, const T2__& beta,
                   std::ostream* pstream__);
template <typename T0__, typename T1__, typename T2__,
          stan::require_all_t<stan::is_stan_scalar<T0__>,
                              stan::is_stan_scalar<T1__>,
                              stan::is_stan_scalar<T2__>>* = nullptr>
stan::promote_args_t<T0__, T1__, T2__>
loglogistic_2_lccdf(const T0__& y_hat, const T1__& mw, const T2__& beta,
                    std::ostream* pstream__);
template <typename T0__, typename T1__,
          stan::require_all_t<stan::is_stan_scalar<T0__>,
                              stan::is_col_vector<T1__>,
                              stan::is_vt_not_complex<T1__>>*>
int
find_interval_elem(const T0__& x, const T1__& sorted_arg__, const int&
                   start_ind, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__,
                             stan::base_type_t<T1__>>;
  int current_statement__ = 0;
  const auto& sorted = stan::math::to_ref(sorted_arg__);
  static constexpr bool propto__ = true;
  // suppress unused var warning
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    int res = std::numeric_limits<int>::min();
    int N = std::numeric_limits<int>::min();
    int max_iter = std::numeric_limits<int>::min();
    local_scalar_t__ left = DUMMY_VAR__;
    local_scalar_t__ right = DUMMY_VAR__;
    int left_ind = std::numeric_limits<int>::min();
    int right_ind = std::numeric_limits<int>::min();
    int iter = std::numeric_limits<int>::min();
    current_statement__ = 51;
    N = stan::math::num_elements(sorted);
    current_statement__ = 53;
    if (stan::math::logical_eq(N, 0)) {
      current_statement__ = 52;
      return 0;
    }
    current_statement__ = 54;
    left_ind = start_ind;
    current_statement__ = 55;
    right_ind = N;
    current_statement__ = 56;
    max_iter = (100 * N);
    current_statement__ = 57;
    left = (stan::model::rvalue(sorted, "sorted",
              stan::model::index_uni(left_ind))
      - x);
    current_statement__ = 58;
    right = (stan::model::rvalue(sorted, "sorted",
               stan::model::index_uni(right_ind))
      - x);
    current_statement__ = 60;
    if (stan::math::logical_lte(0, left)) {
      current_statement__ = 59;
      return (left_ind - 1);
    }
    current_statement__ = 62;
    if (stan::math::logical_eq(0, right)) {
      current_statement__ = 61;
      return (N - 1);
    }
    current_statement__ = 64;
    if (stan::math::logical_gt(0, right)) {
      current_statement__ = 63;
      return N;
    }
    current_statement__ = 65;
    iter = 1;
    current_statement__ = 82;
    while ((stan::math::primitive_value(
              stan::math::logical_gt((right_ind - left_ind), 1))
           &&
           stan::math::primitive_value(
             stan::math::logical_neq(iter, max_iter)))) {
      int mid_ind = std::numeric_limits<int>::min();
      local_scalar_t__ mid = DUMMY_VAR__;
      current_statement__ = 68;
      mid_ind = ((left_ind + right_ind) / 2);
      current_statement__ = 69;
      mid = (stan::model::rvalue(sorted, "sorted",
               stan::model::index_uni(mid_ind))
        - x);
      current_statement__ = 71;
      if (stan::math::logical_eq(mid, 0)) {
        current_statement__ = 70;
        return (mid_ind - 1);
      }
      current_statement__ = 75;
      if (stan::math::logical_lt((left * mid), 0)) {
        current_statement__ = 72;
        right = mid;
        current_statement__ = 73;
        right_ind = mid_ind;
      }
      current_statement__ = 79;
      if (stan::math::logical_lt((right * mid), 0)) {
        current_statement__ = 76;
        left = mid;
        current_statement__ = 77;
        left_ind = mid_ind;
      }
      current_statement__ = 80;
      iter = (iter + 1);
    }
    current_statement__ = 84;
    if (stan::math::logical_eq(iter, max_iter)) {
      current_statement__ = 83;
      if (pstream__) {
        stan::math::stan_print(pstream__,
          "Maximum number of iterations reached.");
        *(pstream__) << std::endl;
      }
    }
    current_statement__ = 85;
    return left_ind;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
template <typename T0__, typename T1__, typename T2__, typename T3__,
          typename T4__,
          stan::require_all_t<stan::is_stan_scalar<T0__>,
                              stan::is_stan_scalar<T1__>,
                              stan::is_stan_scalar<T2__>,
                              stan::is_stan_scalar<T3__>,
                              stan::is_stan_scalar<T4__>>*>
stan::promote_args_t<T0__, T1__, T2__, T3__, T4__>
linearInterp(const T0__& t_x, const T1__& t_before, const T2__& t_after,
             const T3__& y_before, const T4__& y_after, std::ostream*
             pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__, T1__, T2__, T3__, T4__>;
  int current_statement__ = 0;
  static constexpr bool propto__ = true;
  // suppress unused var warning
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    local_scalar_t__ linInterp_hat = DUMMY_VAR__;
    current_statement__ = 88;
    linInterp_hat = (y_before + (((t_x - t_before) * (y_after - y_before)) /
      (t_after - t_before)));
    current_statement__ = 89;
    return linInterp_hat;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
template <bool propto__, typename T0__, typename T1__, typename T2__,
          stan::require_all_t<stan::is_stan_scalar<T0__>,
                              stan::is_stan_scalar<T1__>,
                              stan::is_stan_scalar<T2__>>*>
stan::promote_args_t<T0__, T1__, T2__>
loglogistic_2_lpdf(const T0__& y_hat, const T1__& mw, const T2__& beta,
                   std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__, T1__, T2__>;
  int current_statement__ = 0;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    current_statement__ = 91;
    return (((stan::math::log(beta) - stan::math::log(mw)) + ((beta - 1) *
           (stan::math::log(y_hat) - stan::math::log(mw)))) - (2 *
           stan::math::log1p_exp((beta * (stan::math::log(y_hat) -
             stan::math::log(mw))))));
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
template <typename T0__, typename T1__, typename T2__,
          stan::require_all_t<stan::is_stan_scalar<T0__>,
                              stan::is_stan_scalar<T1__>,
                              stan::is_stan_scalar<T2__>>*>
stan::promote_args_t<T0__, T1__, T2__>
loglogistic_2_lcdf(const T0__& y_hat, const T1__& mw, const T2__& beta,
                   std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__, T1__, T2__>;
  int current_statement__ = 0;
  static constexpr bool propto__ = true;
  // suppress unused var warning
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    current_statement__ = 93;
    return -stan::math::log1p_exp((-beta * (stan::math::log(y_hat) -
              stan::math::log(mw))));
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
template <typename T0__, typename T1__, typename T2__,
          stan::require_all_t<stan::is_stan_scalar<T0__>,
                              stan::is_stan_scalar<T1__>,
                              stan::is_stan_scalar<T2__>>*>
stan::promote_args_t<T0__, T1__, T2__>
loglogistic_2_lccdf(const T0__& y_hat, const T1__& mw, const T2__& beta,
                    std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__, T1__, T2__>;
  int current_statement__ = 0;
  static constexpr bool propto__ = true;
  // suppress unused var warning
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    current_statement__ = 95;
    return -stan::math::log1p_exp((beta * (stan::math::log(y_hat) -
              stan::math::log(mw))));
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
#include <stan_meta_header.hpp>
class model_GUTS_hb_only final : public model_base_crtp<model_GUTS_hb_only> {
private:
  int nDatasets;
  int nGroup;
  int nData_Nsurv;
  std::vector<int> Nsurv;
  std::vector<int> Nprec;
  std::vector<double> tNsurv;
  int idS_lw;
  int idS_up;
  double hbMean_log10;
  double hbSD_log10;
public:
  ~model_GUTS_hb_only() {}
  model_GUTS_hb_only(stan::io::var_context& context__, unsigned int
                     random_seed__ = 0, std::ostream* pstream__ = nullptr)
      : model_base_crtp(0) {
    int current_statement__ = 0;
    using local_scalar_t__ = double;
    boost::ecuyer1988 base_rng__ =
      stan::services::util::create_rng(random_seed__, 0);
    // suppress unused var warning
    (void) base_rng__;
    static constexpr const char* function__ =
      "model_GUTS_hb_only_namespace::model_GUTS_hb_only";
    // suppress unused var warning
    (void) function__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      current_statement__ = 24;
      context__.validate_dims("data initialization", "nDatasets", "int",
        std::vector<size_t>{});
      nDatasets = std::numeric_limits<int>::min();
      current_statement__ = 24;
      nDatasets = context__.vals_i("nDatasets")[(1 - 1)];
      current_statement__ = 24;
      stan::math::check_greater_or_equal(function__, "nDatasets", nDatasets,
        1);
      current_statement__ = 25;
      context__.validate_dims("data initialization", "nGroup", "int",
        std::vector<size_t>{});
      nGroup = std::numeric_limits<int>::min();
      current_statement__ = 25;
      nGroup = context__.vals_i("nGroup")[(1 - 1)];
      current_statement__ = 25;
      stan::math::check_greater_or_equal(function__, "nGroup", nGroup, 1);
      current_statement__ = 26;
      context__.validate_dims("data initialization", "nData_Nsurv", "int",
        std::vector<size_t>{});
      nData_Nsurv = std::numeric_limits<int>::min();
      current_statement__ = 26;
      nData_Nsurv = context__.vals_i("nData_Nsurv")[(1 - 1)];
      current_statement__ = 26;
      stan::math::check_greater_or_equal(function__, "nData_Nsurv",
        nData_Nsurv, 1);
      current_statement__ = 27;
      stan::math::validate_non_negative_index("Nsurv", "nData_Nsurv",
        nData_Nsurv);
      current_statement__ = 28;
      context__.validate_dims("data initialization", "Nsurv", "int",
        std::vector<size_t>{static_cast<size_t>(nData_Nsurv)});
      Nsurv = std::vector<int>(nData_Nsurv, std::numeric_limits<int>::min());
      current_statement__ = 28;
      Nsurv = context__.vals_i("Nsurv");
      current_statement__ = 29;
      stan::math::validate_non_negative_index("Nprec", "nData_Nsurv",
        nData_Nsurv);
      current_statement__ = 30;
      context__.validate_dims("data initialization", "Nprec", "int",
        std::vector<size_t>{static_cast<size_t>(nData_Nsurv)});
      Nprec = std::vector<int>(nData_Nsurv, std::numeric_limits<int>::min());
      current_statement__ = 30;
      Nprec = context__.vals_i("Nprec");
      current_statement__ = 31;
      stan::math::validate_non_negative_index("tNsurv", "nData_Nsurv",
        nData_Nsurv);
      current_statement__ = 32;
      context__.validate_dims("data initialization", "tNsurv", "double",
        std::vector<size_t>{static_cast<size_t>(nData_Nsurv)});
      tNsurv = std::vector<double>(nData_Nsurv,
                 std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 32;
      tNsurv = context__.vals_r("tNsurv");
      current_statement__ = 33;
      context__.validate_dims("data initialization", "idS_lw", "int",
        std::vector<size_t>{});
      idS_lw = std::numeric_limits<int>::min();
      current_statement__ = 33;
      idS_lw = context__.vals_i("idS_lw")[(1 - 1)];
      current_statement__ = 33;
      stan::math::check_greater_or_equal(function__, "idS_lw", idS_lw, 1);
      current_statement__ = 34;
      context__.validate_dims("data initialization", "idS_up", "int",
        std::vector<size_t>{});
      idS_up = std::numeric_limits<int>::min();
      current_statement__ = 34;
      idS_up = context__.vals_i("idS_up")[(1 - 1)];
      current_statement__ = 34;
      stan::math::check_greater_or_equal(function__, "idS_up", idS_up, 1);
      current_statement__ = 35;
      context__.validate_dims("data initialization", "hbMean_log10",
        "double", std::vector<size_t>{});
      hbMean_log10 = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 35;
      hbMean_log10 = context__.vals_r("hbMean_log10")[(1 - 1)];
      current_statement__ = 36;
      context__.validate_dims("data initialization", "hbSD_log10", "double",
        std::vector<size_t>{});
      hbSD_log10 = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 36;
      hbSD_log10 = context__.vals_r("hbSD_log10")[(1 - 1)];
      current_statement__ = 37;
      stan::math::validate_non_negative_index("Psurv_hat", "nData_Nsurv",
        nData_Nsurv);
      current_statement__ = 38;
      stan::math::validate_non_negative_index("Conditional_Psurv_hat",
        "nData_Nsurv", nData_Nsurv);
      current_statement__ = 39;
      stan::math::validate_non_negative_index("Nsurv_ppc", "nData_Nsurv",
        nData_Nsurv);
      current_statement__ = 40;
      stan::math::validate_non_negative_index("Nsurv_sim", "nData_Nsurv",
        nData_Nsurv);
      current_statement__ = 41;
      stan::math::validate_non_negative_index("Nsurv_sim_prec",
        "nData_Nsurv", nData_Nsurv);
      current_statement__ = 42;
      stan::math::validate_non_negative_index("log_lik", "nData_Nsurv",
        nData_Nsurv);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    num_params_r__ = 1;
  }
  inline std::string model_name() const final {
    return "model_GUTS_hb_only";
  }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.32.2",
             "stancflags = --allow-undefined"};
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI,
            stan::require_vector_like_t<VecR>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR>
  log_prob_impl(VecR& params_r__, VecI& params_i__, std::ostream*
                pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    static constexpr const char* function__ =
      "model_GUTS_hb_only_namespace::log_prob";
    // suppress unused var warning
    (void) function__;
    try {
      local_scalar_t__ sigma = DUMMY_VAR__;
      current_statement__ = 1;
      sigma = in__.template read<local_scalar_t__>();
      local_scalar_t__ hb_log10 = DUMMY_VAR__;
      local_scalar_t__ param = DUMMY_VAR__;
      Eigen::Matrix<local_scalar_t__,-1,1> Psurv_hat =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(nData_Nsurv,
          DUMMY_VAR__);
      Eigen::Matrix<local_scalar_t__,-1,1> Conditional_Psurv_hat =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(nData_Nsurv,
          DUMMY_VAR__);
      current_statement__ = 10;
      hb_log10 = (hbMean_log10 + (hbSD_log10 * sigma));
      current_statement__ = 15;
      for (int i = 1; i <= nData_Nsurv; ++i) {
        current_statement__ = 11;
        param = stan::math::pow(10, hb_log10);
        current_statement__ = 12;
        stan::model::assign(Psurv_hat,
          stan::math::exp((-param *
            stan::model::rvalue(tNsurv, "tNsurv", stan::model::index_uni(i)))),
          "assigning variable Psurv_hat", stan::model::index_uni(i));
        current_statement__ = 13;
        stan::model::assign(Conditional_Psurv_hat,
          (stan::math::logical_eq(i, 1) ? stan::model::rvalue(Psurv_hat,
                                            "Psurv_hat",
                                            stan::model::index_uni(i)) : (
          stan::model::rvalue(Psurv_hat, "Psurv_hat",
            stan::model::index_uni(i)) /
          stan::model::rvalue(Psurv_hat, "Psurv_hat",
            stan::model::index_uni((i - 1))))),
          "assigning variable Conditional_Psurv_hat",
          stan::model::index_uni(i));
      }
      current_statement__ = 3;
      stan::math::check_greater_or_equal(function__, "param", param, 0);
      current_statement__ = 4;
      stan::math::check_greater_or_equal(function__, "Psurv_hat", Psurv_hat,
        0);
      current_statement__ = 4;
      stan::math::check_less_or_equal(function__, "Psurv_hat", Psurv_hat, 1);
      current_statement__ = 5;
      stan::math::check_greater_or_equal(function__, "Conditional_Psurv_hat",
        Conditional_Psurv_hat, 0);
      current_statement__ = 5;
      stan::math::check_less_or_equal(function__, "Conditional_Psurv_hat",
        Conditional_Psurv_hat, 1);
      {
        current_statement__ = 22;
        lp_accum__.add(stan::math::normal_lpdf<false>(sigma, 0, 1));
        current_statement__ = 23;
        lp_accum__.add(stan::math::binomial_lpmf<false>(
                         stan::model::rvalue(Nsurv, "Nsurv",
                           stan::model::index_min_max(idS_lw, idS_up)),
                         stan::model::rvalue(Nprec, "Nprec",
                           stan::model::index_min_max(idS_lw, idS_up)),
                         stan::model::rvalue(Conditional_Psurv_hat,
                           "Conditional_Psurv_hat",
                           stan::model::index_min_max(idS_lw, idS_up))));
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
  }
  template <typename RNG, typename VecR, typename VecI, typename VecVar,
            stan::require_vector_like_vt<std::is_floating_point,
            VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral,
            VecI>* = nullptr, stan::require_vector_vt<std::is_floating_point,
            VecVar>* = nullptr>
  inline void
  write_array_impl(RNG& base_rng__, VecR& params_r__, VecI& params_i__,
                   VecVar& vars__, const bool
                   emit_transformed_parameters__ = true, const bool
                   emit_generated_quantities__ = true, std::ostream*
                   pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    static constexpr bool propto__ = true;
    // suppress unused var warning
    (void) propto__;
    double lp__ = 0.0;
    // suppress unused var warning
    (void) lp__;
    int current_statement__ = 0;
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    constexpr bool jacobian__ = false;
    static constexpr const char* function__ =
      "model_GUTS_hb_only_namespace::write_array";
    // suppress unused var warning
    (void) function__;
    try {
      double sigma = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 1;
      sigma = in__.template read<local_scalar_t__>();
      double hb_log10 = std::numeric_limits<double>::quiet_NaN();
      double param = std::numeric_limits<double>::quiet_NaN();
      Eigen::Matrix<double,-1,1> Psurv_hat =
        Eigen::Matrix<double,-1,1>::Constant(nData_Nsurv,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,1> Conditional_Psurv_hat =
        Eigen::Matrix<double,-1,1>::Constant(nData_Nsurv,
          std::numeric_limits<double>::quiet_NaN());
      out__.write(sigma);
      if (stan::math::logical_negation(
            (stan::math::primitive_value(emit_transformed_parameters__) ||
            stan::math::primitive_value(emit_generated_quantities__)))) {
        return ;
      }
      current_statement__ = 10;
      hb_log10 = (hbMean_log10 + (hbSD_log10 * sigma));
      current_statement__ = 15;
      for (int i = 1; i <= nData_Nsurv; ++i) {
        current_statement__ = 11;
        param = stan::math::pow(10, hb_log10);
        current_statement__ = 12;
        stan::model::assign(Psurv_hat,
          stan::math::exp((-param *
            stan::model::rvalue(tNsurv, "tNsurv", stan::model::index_uni(i)))),
          "assigning variable Psurv_hat", stan::model::index_uni(i));
        current_statement__ = 13;
        stan::model::assign(Conditional_Psurv_hat,
          (stan::math::logical_eq(i, 1) ? stan::model::rvalue(Psurv_hat,
                                            "Psurv_hat",
                                            stan::model::index_uni(i)) : (
          stan::model::rvalue(Psurv_hat, "Psurv_hat",
            stan::model::index_uni(i)) /
          stan::model::rvalue(Psurv_hat, "Psurv_hat",
            stan::model::index_uni((i - 1))))),
          "assigning variable Conditional_Psurv_hat",
          stan::model::index_uni(i));
      }
      current_statement__ = 3;
      stan::math::check_greater_or_equal(function__, "param", param, 0);
      current_statement__ = 4;
      stan::math::check_greater_or_equal(function__, "Psurv_hat", Psurv_hat,
        0);
      current_statement__ = 4;
      stan::math::check_less_or_equal(function__, "Psurv_hat", Psurv_hat, 1);
      current_statement__ = 5;
      stan::math::check_greater_or_equal(function__, "Conditional_Psurv_hat",
        Conditional_Psurv_hat, 0);
      current_statement__ = 5;
      stan::math::check_less_or_equal(function__, "Conditional_Psurv_hat",
        Conditional_Psurv_hat, 1);
      if (emit_transformed_parameters__) {
        out__.write(hb_log10);
        out__.write(param);
        out__.write(Psurv_hat);
        out__.write(Conditional_Psurv_hat);
      }
      if (stan::math::logical_negation(emit_generated_quantities__)) {
        return ;
      }
      std::vector<int> Nsurv_ppc =
        std::vector<int>(nData_Nsurv, std::numeric_limits<int>::min());
      std::vector<int> Nsurv_sim =
        std::vector<int>(nData_Nsurv, std::numeric_limits<int>::min());
      std::vector<int> Nsurv_sim_prec =
        std::vector<int>(nData_Nsurv, std::numeric_limits<int>::min());
      Eigen::Matrix<double,-1,1> log_lik =
        Eigen::Matrix<double,-1,1>::Constant(nData_Nsurv,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 21;
      for (int i = idS_lw; i <= idS_up; ++i) {
        current_statement__ = 16;
        stan::model::assign(Nsurv_ppc,
          stan::math::binomial_rng(
            stan::model::rvalue(Nprec, "Nprec", stan::model::index_uni(i)),
            stan::model::rvalue(Conditional_Psurv_hat,
              "Conditional_Psurv_hat", stan::model::index_uni(i)), base_rng__),
          "assigning variable Nsurv_ppc", stan::model::index_uni(i));
        current_statement__ = 17;
        stan::model::assign(Nsurv_sim_prec,
          (stan::math::logical_eq(i, idS_lw) ? stan::model::rvalue(Nprec,
                                                 "Nprec",
                                                 stan::model::index_uni(i)) : 
          stan::model::rvalue(Nsurv_sim, "Nsurv_sim",
            stan::model::index_uni((i - 1)))),
          "assigning variable Nsurv_sim_prec", stan::model::index_uni(i));
        current_statement__ = 18;
        stan::model::assign(Nsurv_sim,
          stan::math::binomial_rng(
            stan::model::rvalue(Nsurv_sim_prec, "Nsurv_sim_prec",
              stan::model::index_uni(i)),
            stan::model::rvalue(Conditional_Psurv_hat,
              "Conditional_Psurv_hat", stan::model::index_uni(i)), base_rng__),
          "assigning variable Nsurv_sim", stan::model::index_uni(i));
        current_statement__ = 19;
        stan::model::assign(log_lik,
          stan::math::binomial_lpmf<false>(
            stan::model::rvalue(Nsurv, "Nsurv",
              stan::model::index_min_max(idS_lw, idS_up)),
            stan::model::rvalue(Nprec, "Nprec",
              stan::model::index_min_max(idS_lw, idS_up)),
            stan::model::rvalue(Conditional_Psurv_hat,
              "Conditional_Psurv_hat",
              stan::model::index_min_max(idS_lw, idS_up))),
          "assigning variable log_lik", stan::model::index_uni(i));
      }
      out__.write(Nsurv_ppc);
      out__.write(Nsurv_sim);
      out__.write(Nsurv_sim_prec);
      out__.write(log_lik);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, typename VecI,
            stan::require_vector_t<VecVar>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void
  unconstrain_array_impl(const VecVar& params_r__, const VecI& params_i__,
                         VecVar& vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      local_scalar_t__ sigma = DUMMY_VAR__;
      current_statement__ = 1;
      sigma = in__.read<local_scalar_t__>();
      out__.write(sigma);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, stan::require_vector_t<VecVar>* = nullptr>
  inline void
  transform_inits_impl(const stan::io::var_context& context__, VecVar&
                       vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      current_statement__ = 1;
      context__.validate_dims("parameter initialization", "sigma", "double",
        std::vector<size_t>{});
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      local_scalar_t__ sigma = DUMMY_VAR__;
      current_statement__ = 1;
      sigma = context__.vals_r("sigma")[(1 - 1)];
      out__.write(sigma);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  inline void
  get_param_names(std::vector<std::string>& names__, const bool
                  emit_transformed_parameters__ = true, const bool
                  emit_generated_quantities__ = true) const {
    names__ = std::vector<std::string>{"sigma"};
    if (emit_transformed_parameters__) {
      std::vector<std::string>
        temp{"hb_log10", "param", "Psurv_hat", "Conditional_Psurv_hat"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {
      std::vector<std::string>
        temp{"Nsurv_ppc", "Nsurv_sim", "Nsurv_sim_prec", "log_lik"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  get_dims(std::vector<std::vector<size_t>>& dimss__, const bool
           emit_transformed_parameters__ = true, const bool
           emit_generated_quantities__ = true) const {
    dimss__ = std::vector<std::vector<size_t>>{std::vector<size_t>{}};
    if (emit_transformed_parameters__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{}, std::vector<size_t>{},
             std::vector<size_t>{static_cast<size_t>(nData_Nsurv)},
             std::vector<size_t>{static_cast<size_t>(nData_Nsurv)}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{static_cast<size_t>(nData_Nsurv)},
             std::vector<size_t>{static_cast<size_t>(nData_Nsurv)},
             std::vector<size_t>{static_cast<size_t>(nData_Nsurv)},
             std::vector<size_t>{static_cast<size_t>(nData_Nsurv)}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  constrained_param_names(std::vector<std::string>& param_names__, bool
                          emit_transformed_parameters__ = true, bool
                          emit_generated_quantities__ = true) const final {
    param_names__.emplace_back(std::string() + "sigma");
    if (emit_transformed_parameters__) {
      param_names__.emplace_back(std::string() + "hb_log10");
      param_names__.emplace_back(std::string() + "param");
      for (int sym1__ = 1; sym1__ <= nData_Nsurv; ++sym1__) {
        param_names__.emplace_back(std::string() + "Psurv_hat" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= nData_Nsurv; ++sym1__) {
        param_names__.emplace_back(std::string() + "Conditional_Psurv_hat" +
          '.' + std::to_string(sym1__));
      }
    }
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= nData_Nsurv; ++sym1__) {
        param_names__.emplace_back(std::string() + "Nsurv_ppc" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= nData_Nsurv; ++sym1__) {
        param_names__.emplace_back(std::string() + "Nsurv_sim" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= nData_Nsurv; ++sym1__) {
        param_names__.emplace_back(std::string() + "Nsurv_sim_prec" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= nData_Nsurv; ++sym1__) {
        param_names__.emplace_back(std::string() + "log_lik" + '.' +
          std::to_string(sym1__));
      }
    }
  }
  inline void
  unconstrained_param_names(std::vector<std::string>& param_names__, bool
                            emit_transformed_parameters__ = true, bool
                            emit_generated_quantities__ = true) const final {
    param_names__.emplace_back(std::string() + "sigma");
    if (emit_transformed_parameters__) {
      param_names__.emplace_back(std::string() + "hb_log10");
      param_names__.emplace_back(std::string() + "param");
      for (int sym1__ = 1; sym1__ <= nData_Nsurv; ++sym1__) {
        param_names__.emplace_back(std::string() + "Psurv_hat" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= nData_Nsurv; ++sym1__) {
        param_names__.emplace_back(std::string() + "Conditional_Psurv_hat" +
          '.' + std::to_string(sym1__));
      }
    }
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= nData_Nsurv; ++sym1__) {
        param_names__.emplace_back(std::string() + "Nsurv_ppc" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= nData_Nsurv; ++sym1__) {
        param_names__.emplace_back(std::string() + "Nsurv_sim" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= nData_Nsurv; ++sym1__) {
        param_names__.emplace_back(std::string() + "Nsurv_sim_prec" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= nData_Nsurv; ++sym1__) {
        param_names__.emplace_back(std::string() + "log_lik" + '.' +
          std::to_string(sym1__));
      }
    }
  }
  inline std::string get_constrained_sizedtypes() const {
    return std::string("[{\"name\":\"sigma\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"hb_log10\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"param\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"Psurv_hat\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(nData_Nsurv) + "},\"block\":\"transformed_parameters\"},{\"name\":\"Conditional_Psurv_hat\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(nData_Nsurv) + "},\"block\":\"transformed_parameters\"},{\"name\":\"Nsurv_ppc\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(nData_Nsurv) + ",\"element_type\":{\"name\":\"int\"}},\"block\":\"generated_quantities\"},{\"name\":\"Nsurv_sim\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(nData_Nsurv) + ",\"element_type\":{\"name\":\"int\"}},\"block\":\"generated_quantities\"},{\"name\":\"Nsurv_sim_prec\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(nData_Nsurv) + ",\"element_type\":{\"name\":\"int\"}},\"block\":\"generated_quantities\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(nData_Nsurv) + "},\"block\":\"generated_quantities\"}]");
  }
  inline std::string get_unconstrained_sizedtypes() const {
    return std::string("[{\"name\":\"sigma\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"hb_log10\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"param\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"Psurv_hat\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(nData_Nsurv) + "},\"block\":\"transformed_parameters\"},{\"name\":\"Conditional_Psurv_hat\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(nData_Nsurv) + "},\"block\":\"transformed_parameters\"},{\"name\":\"Nsurv_ppc\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(nData_Nsurv) + ",\"element_type\":{\"name\":\"int\"}},\"block\":\"generated_quantities\"},{\"name\":\"Nsurv_sim\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(nData_Nsurv) + ",\"element_type\":{\"name\":\"int\"}},\"block\":\"generated_quantities\"},{\"name\":\"Nsurv_sim_prec\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(nData_Nsurv) + ",\"element_type\":{\"name\":\"int\"}},\"block\":\"generated_quantities\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(nData_Nsurv) + "},\"block\":\"generated_quantities\"}]");
  }
  // Begin method overload boilerplate
  template <typename RNG> inline void
  write_array(RNG& base_rng, Eigen::Matrix<double,-1,1>& params_r,
              Eigen::Matrix<double,-1,1>& vars, const bool
              emit_transformed_parameters = true, const bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = 1;
    const size_t num_transformed = emit_transformed_parameters * ((((1 + 1) +
      nData_Nsurv) + nData_Nsurv));
    const size_t num_gen_quantities = emit_generated_quantities *
      ((((nData_Nsurv + nData_Nsurv) + nData_Nsurv) + nData_Nsurv));
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    std::vector<int> params_i;
    vars = Eigen::Matrix<double,-1,1>::Constant(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <typename RNG> inline void
  write_array(RNG& base_rng, std::vector<double>& params_r, std::vector<int>&
              params_i, std::vector<double>& vars, bool
              emit_transformed_parameters = true, bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = 1;
    const size_t num_transformed = emit_transformed_parameters * ((((1 + 1) +
      nData_Nsurv) + nData_Nsurv));
    const size_t num_gen_quantities = emit_generated_quantities *
      ((((nData_Nsurv + nData_Nsurv) + nData_Nsurv) + nData_Nsurv));
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    vars = std::vector<double>(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(Eigen::Matrix<T_,-1,1>& params_r, std::ostream* pstream = nullptr) const {
    Eigen::Matrix<int,-1,1> params_i;
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(std::vector<T_>& params_r, std::vector<int>& params_i,
           std::ostream* pstream = nullptr) const {
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  inline void
  transform_inits(const stan::io::var_context& context,
                  Eigen::Matrix<double,-1,1>& params_r, std::ostream*
                  pstream = nullptr) const final {
    std::vector<double> params_r_vec(params_r.size());
    std::vector<int> params_i;
    transform_inits(context, params_i, params_r_vec, pstream);
    params_r = Eigen::Map<Eigen::Matrix<double,-1,1>>(params_r_vec.data(),
                 params_r_vec.size());
  }
  inline void
  transform_inits(const stan::io::var_context& context, std::vector<int>&
                  params_i, std::vector<double>& vars, std::ostream*
                  pstream__ = nullptr) const {
    vars.resize(num_params_r__);
    transform_inits_impl(context, vars, pstream__);
  }
  inline void
  unconstrain_array(const std::vector<double>& params_constrained,
                    std::vector<double>& params_unconstrained, std::ostream*
                    pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = std::vector<double>(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
  inline void
  unconstrain_array(const Eigen::Matrix<double,-1,1>& params_constrained,
                    Eigen::Matrix<double,-1,1>& params_unconstrained,
                    std::ostream* pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = Eigen::Matrix<double,-1,1>::Constant(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
};
}
using stan_model = model_GUTS_hb_only_namespace::model_GUTS_hb_only;
#ifndef USING_R
// Boilerplate
stan::model::model_base&
new_model(stan::io::var_context& data_context, unsigned int seed,
          std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_GUTS_hb_only_namespace::profiles__;
}
#endif
#endif
