% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_bio.R
\name{SummaryBiomass}
\alias{SummaryBiomass}
\title{SummaryBiomass}
\usage{
SummaryBiomass(
  data,
  site,
  plot,
  exp_factor,
  status,
  decay_class,
  species,
  dbh,
  ht,
  sp_codes = "4letter",
  units = "metric",
  results = "by_plot"
)
}
\arguments{
\item{data}{A dataframe or tibble. Each row must be an observation of an individual tree.}

\item{site}{Must be a character variable (column) in the provided dataframe or tibble. Describes the broader location or forest where the data were collected.}

\item{plot}{Must be a character variable (column) in the provided dataframe or tibble. Identifies the plot in which the individual tree was measured.}

\item{exp_factor}{Must be a numeric variable (column) in the provided dataframe or tibble. The expansion factor specifies the number of trees per hectare (or per acre) that a given plot tree represents.}

\item{status}{Must be a character variable (column) in the provided dataframe or tibble. Specifies whether the individual tree is alive (1) or dead (0).}

\item{decay_class}{Must be a character variable (column) in the provided dataframe or tibble. For standing dead trees, the decay class should be 1, 2, 3, 4, or 5 (see README file for more detail). For live trees, the decay class should be NA or 0.}

\item{species}{Must be a character variable (column) in the provided dataframe or tibble. Specifies the species of the individual tree. Must follow four-letter species code or FIA naming conventions (see README file for more detail).}

\item{dbh}{Must be a numeric variable (column) in the provided dataframe or tibble. Provides the diameter at breast height (DBH) of the individual tree in either centimeters or inches.}

\item{ht}{Must be a numeric variable (column) in the provided dataframe or tibble. Provides the height of the individual tree in either meters or feet.}

\item{sp_codes}{Not a variable (column) in the provided dataframe or tibble. Specifies whether the species variable follows the four-letter code or FIA naming convention (see README file for more detail). Must be set to either "4letter" or "fia". The default is set to "4letter".}

\item{units}{Not a variable (column) in the provided dataframe or tibble. Specifies (1) whether the dbh and ht variables were measured using metric (centimeters and meters) or imperial (inches and feet) units; (2) whether the expansion factor is in metric (stems per hectare) or imperial (stems per acre) units; and (3) whether results will be given in metric (megagrams per hectare) or imperial (US tons per acre) units. Must be set to either "metric" or "imperial". The default is set to "metric".}

\item{results}{Not a variable (column) in the provided dataframe or tibble. Specifies whether the results will be summarized by plot or by plot as well as species. Must be set to either "by_plot" or "by_species." The default is set to "by_plot".}
}
\value{
A dataframe with the following columns:
\itemize{
\item site: as described above
\item plot: as described above
\item species: if results argument was set to "by_species"
\item live_Mg_ha (or live_ton_ac): above-ground live tree biomass in megagrams per hectare (or US tons per acre)
\item dead_Mg_ha (or dead_ton_ac): above-ground dead tree biomass in megagrams per hectare (or US tons per acre)
}
}
\description{
Uses Forest Inventory and Analysis (FIA) Regional Biomass Equations to estimate above-ground stem, bark, and branch tree biomass. The package will summarize by plot or by plot as well as species. The package uses the California equation set and should not be used for data from other regions.
}
\examples{
SummaryBiomass(data = bio_demo_data,
               site = "Forest",
               plot = "Plot_id",
               exp_factor = "SPH",
               status = "Live",
               decay_class = "Decay",
               species = "SPP",
               dbh = "DBH_CM",
               ht = "HT_M",
               results = "by_species")

}
