% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Meta2pathway.R
\name{Meta2pathway}
\alias{Meta2pathway}
\title{Meta2pathway}
\usage{
Meta2pathway(metadf)
}
\arguments{
\item{metadf}{A data frame including metabolites with compound ID and abundance.}
}
\value{
meta2path_res A data frame containing metabolites with compound ID and predicted KEGG pathways.
}
\description{
A function is used to predict the metabolic functional pathways according to the abundance of metabolites based on the algorithm Pathway Activity Profiling (PAPi).
Note: Please use compound IDs in KEGG database to replace the names of metabolites. For example, C00002 means ATP or Adenosine 5'-triphosphate in KEGG.
Users also can use Metaboanalyst (https://www.metaboanalyst.ca/MetaboAnalyst/upload/ConvertView.xhtml)(Pang, et al., 2022) to convert the metabolites names to compound IDs.
If metabolites do not have compound IDs, keep the original names.
See data example "Meta2pathway.eg" for details.
}
\examples{
Meta2pathway_res <- Meta2pathway(metadf = Meta2pathway.eg)
}
