% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.R
\name{install.bioinfo}
\alias{install.bioinfo}
\title{Download and install biology software or database}
\usage{
install.bioinfo(name = c(), destdir = c(), name.saved = NULL,
  github.cfg = system.file("extdata", "github.toml", package =
  "BioInstaller"), nongithub.cfg = system.file("extdata", "nongithub.toml",
  package = "BioInstaller"), version = c(), show.all.versions = FALSE,
  show.all.names = FALSE, db = Sys.getenv("BIO_SOFTWARES_DB_ACTIVE",
  system.file("extdata", "softwares_db_demo.yaml", package = "BioInstaller")),
  download.only = FALSE, decompress = TRUE, showWarnings = FALSE,
  verbose = FALSE, ...)
}
\arguments{
\item{name}{Software name}

\item{destdir}{A string, point the install path}

\item{name.saved}{Software name when you want to install different version, you
can use this to point the installed softwares name like 'GATK-3.7'}

\item{github.cfg}{Configuration file of installed by github url,
default is system.file('extdata', 'github.toml', package='BioInstaller')}

\item{nongithub.cfg}{Configuration file of installed by non github url,
default is system.file('extdata', 'nongithub.toml', package='BioInstaller')}

\item{version}{Software version}

\item{show.all.versions}{Logical wheather show all avaliable versions can be install}

\item{show.all.names}{Logical wheather show all avaliable names can be install}

\item{db}{File of saving softwares infomation, default is Sys.getenv('BIO_SOFTWARES_DB_ACTIVE',
system.file('extdata', 'softwares_db_demo.yaml', package = 'BioInstaller'))}

\item{download.only}{Logicol indicating wheather only download source or file (non-github)}

\item{decompress}{Logicol indicating wheather need to decompress the downloaded file, default is TRUE}

\item{showWarnings}{Logical should the warnings on failure be shown?}

\item{verbose}{TRUE is debug mode}

\item{...}{Other key and value paired need be saved in BioInstaller passed to \code{\link{change.info}}}
}
\value{
Bool Value or a list
}
\description{
Download and install biology software or database
}
\examples{
set.biosoftwares.db(sprintf('\%s/.BioInstaller', tempdir()))
install.bioinfo('bwa', sprintf('\%s/bwa', tempdir()), verbose = TRUE)
}
