% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/XGBoostSub_continuous.R
\name{XGBoostSub_con}
\alias{XGBoostSub_con}
\title{XGBoost Model with Modified Loss Function for Subgroup Identification with Continuous Outcomes}
\usage{
XGBoostSub_con(
  X_data,
  y_data,
  trt,
  pi,
  Loss_type = "A_learning",
  params = list(),
  nrounds = 50,
  disable_default_eval_metric = 1,
  verbose = TRUE
)
}
\arguments{
\item{X_data}{The input features matrix.}

\item{y_data}{The input y matrix.}

\item{trt}{The treatment indicator vector. Should take values of 1 or -1, where 1 represents the treatment group and -1 represents the control group.}

\item{pi}{The propensity scores vector, which should range from 0 to 1, representing the probability of assignment to treatment.}

\item{Loss_type}{Type of loss function to use: "A_learning" or "Weight_learning".}

\item{params}{A list of additional parameters for the xgb.train function.}

\item{nrounds}{Number of boosting rounds. Default is 50.}

\item{disable_default_eval_metric}{If 1, default evaluation metric will be disabled.}

\item{verbose}{Logical. If TRUE, training progress will be printed; if FALSE, no progress will be printed.}
}
\value{
Trained XGBoostSub_con model.
}
\description{
Function for training XGBoost model with customized loss function for continuous outcomes
}
\details{
XGBoostSub_con: Function for Training XGBoost Model with Customized Loss Function for continuous outcomes

This function trains an XGBoost model using a customized loss function based on the A-learning and weight-learning.


This function requires the 'xgboost' library. Make sure to install and load the 'xgboost' library before using this function.

After running this function, the returned model can be used like a regular xgboost model.
}
