% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitted_LB.R
\name{fitted_LB}
\alias{fitted_LB}
\title{Fitted values using Logistic Biplot}
\usage{
fitted_LB(object, type = c("link", "response"))
}
\arguments{
\item{object}{BiplotML object}

\item{type}{the type of fitting required. \code{type = "link"} gives output on the logit scale and
\code{type = "response"} gives output on the probability scale}
}
\value{
This function returns the predicted matrix or the log-odds of a binary logistic biplot model.
}
\description{
Compute the predicted matrix or log-odds for a logistic biplot model
}
\examples{
\donttest{
data("Methylation")
LB <- LogBip(Methylation, plot = FALSE)
Theta <- fitted_LB(LB, type = "link")
Pi <- fitted_LB(LB, type = "response")
}
}
\author{
Giovany Babativa <gbabativam@gmail.com>
}
