% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BoneDensityFunctions.R
\name{import_mesh}
\alias{import_mesh}
\title{import surface mesh}
\usage{
import_mesh(surface_mesh_filepath)
}
\arguments{
\item{surface_mesh_filepath}{String. File path to bone models. .stl or .ply}
}
\value{
mesh object
}
\description{
import surface mesh
}
\examples{
\donttest{
  # Download bone model
  url <- "https://github.com/Telfer/BoneDensityMapping/releases/download/v1.0.2/test_CT_femur.stl"
  bone_filepath <- tempfile(fileext = ".stl")
  download.file(url, bone_filepath, mode = "wb")
  import_mesh(bone_filepath)
}
}
\author{
Scott Telfer \email{scott.telfer@gmail.com}
}
