/*
  Copyright (C) 2005-2010 Steven L. Scott

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
*/
#ifndef BOOM_DIFF_HPP_
#define BOOM_DIFF_HPP_

#include <LinAlg/Vector.hpp>
#include <LinAlg/VectorView.hpp>
#include <LinAlg/Types.hpp>

namespace BOOM{

  // Returns the first difference of the given vector.
  Vec diff(const Vec &v, bool leading_zero = false);
  Vec diff(const VectorView &v, bool leading_zero = false);
  Vec diff(const ConstVectorView &v, bool leading_zero = false);

#endif // BOOM_DIFF_HPP_
}
