# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Fit the Bradley-Terry model using the EM or MM algorithm
#' @param W a K*K square matrix of class "dgCMatrix"
#' @param a the shape parameter of the gamma prior 
#' @param b the rate parameter of the gamma prior
#' @param maxit the maximum number of iterations
#' @param epsilon controls the convergence criteria
#' @return A list containing a K*1 matrix with the pi estimate, the N matrix, the number of iterations, and whether the algorithm converged.
BT_EM <- function(W, a, b, maxit = 5000L, epsilon = 1e-3) {
    .Call('BradleyTerryScalable_BT_EM', PACKAGE = 'BradleyTerryScalable', W, a, b, maxit, epsilon)
}

btprob_vec <- function(pi) {
    .Call('BradleyTerryScalable_btprob_vec', PACKAGE = 'BradleyTerryScalable', pi)
}

fitted_vec <- function(pi, N) {
    .Call('BradleyTerryScalable_fitted_vec', PACKAGE = 'BradleyTerryScalable', pi, N)
}

ILSR <- function(W, maxit = 5000L, epsilon = 1e-3) {
    .Call('BradleyTerryScalable_ILSR', PACKAGE = 'BradleyTerryScalable', W, maxit, epsilon)
}

