% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FCTi-initilization.R
\name{internal-intilisation}
\alias{initCensoring}
\alias{initData}
\alias{initHypothesis}
\alias{initN}
\alias{initSpace}
\alias{initStrata}
\alias{initSurvival}
\alias{initThreshold}
\alias{initWscheme}
\alias{internal-intilisation}
\title{internal functions for BuyseTest - intilisation}
\usage{
initCensoring(censoring, endpoint, type, D, D.TTE, treatment, strata)

initData(dataT, dataC, type, endpoint, D, censoring, index.strataT,
  index.strataC, n.strata, method, D.TTE, threshold, Wscheme = NULL, trace,
  test = TRUE)

initN(n)

initHypothesis(hypothesis, type, D)

initSpace(nchar)

initStrata(strata, dataT, dataC, n.Treatment, n.Control, endpoint, censoring)

initSurvival(M.Treatment, M.Control, M.delta_Treatment, M.delta_Control,
  endpoint, D.TTE, type, threshold, index.strataT, index.strataC, n.strata,
  method)

initThreshold(threshold, type, D, method, endpoint)

initWscheme(endpoint, D, endpoint.TTE, D.TTE, threshold, type)
}
\description{
Functions called by \code{\link{BuyseTest}} to initialize the arguments.
}
\details{
All functions performs test to check the validity of the argument. In addition: \cr

\code{initCensoring}: If no TTE and censoring is full of NA, set it to NULL. Else when censoring contains NA for the non-TTE endpoints, remove them. \cr
\code{initStrata}: merge the strata into one with the interaction function and compute the index of the observations relative to each strata. \cr
\code{initThreshold}: set default threshold to 1e-12 expect for binary variable where it is set to 1. 
Also set null threshold to a small positive value (0->1e-12) 
- the rational being we consider a pair favorable if X>Y ie X>=Y+1e-12. When using a threshold e.g. 5 we want X>=Y+5 and not X>Y+5, especially when the measurement is discrete. \cr
}
\keyword{BuyseTest}
\keyword{function}
\keyword{internal}

