/*
 * BiologicalInferences.java
 *
 * Created on October 23, 2005, 13:04 AM
 */

package org.neptuneinc.cadstat.plots;

import java.io.File;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionListener;

import org.neptuneinc.cadstat.utils.RUtils;
import org.rosuda.JGR.JGR;

/**
 *
 * @author  Pasha Minallah
 * @author  Mark Fitzgerald
 */
public class BiologicalInferences extends JDialog implements ListSelectionListener, DocumentListener
{
  /**
   * Creates new form BiologicalInferences
   */
  public BiologicalInferences()
  {
    this.initComponents();

    JTextField[] textFields = {dataDir, coeffs, bcnt, taxMerge, opTax, maxLike};

    for (JTextField textField : textFields)
    {
      textField.getDocument().addDocumentListener(this);
    }

    this.updateValidity();
  }

  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the Form Editor.
   */
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {

    optionsGroup = new javax.swing.ButtonGroup();
    dataDirLabel = new javax.swing.JLabel();
    dataDir = new javax.swing.JTextField();
    dataDirBrowse = new javax.swing.JButton();
    runAll = new javax.swing.JRadioButton();
    importTaxMerge = new javax.swing.JRadioButton();
    importOpTax = new javax.swing.JRadioButton();
    separator1 = new javax.swing.JSeparator();
    coeffsLabel = new javax.swing.JLabel();
    coeffs = new javax.swing.JTextField();
    coeffsBrowse = new javax.swing.JButton();
    bcntLabel = new javax.swing.JLabel();
    bcnt = new javax.swing.JTextField();
    bcntBrowse = new javax.swing.JButton();
    taxMergeLabel = new javax.swing.JLabel();
    taxMerge = new javax.swing.JTextField();
    taxMergeBrowse = new javax.swing.JButton();
    opTaxLabel = new javax.swing.JLabel();
    opTax = new javax.swing.JTextField();
    opTaxBrowse = new javax.swing.JButton();
    maxLikeLabel = new javax.swing.JLabel();
    maxLike = new javax.swing.JTextField();
    maxLikeBrowse = new javax.swing.JButton();
    separator2 = new javax.swing.JSeparator();
    cancelButton = new javax.swing.JButton();
    submitButton = new javax.swing.JButton();
    helpButton = new javax.swing.JButton();

    setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
    setTitle("Biological Inferences");

    dataDirLabel.setText("Data Directory:");

    dataDir.setEditable(false);
    String workingDir = RUtils.evalAsString("getwd()");
    workingDir = workingDir != null ? workingDir.replace('\\', '/') : System.getProperty("user.home");
    dataDir.setText(workingDir);

    dataDirBrowse.setText("Browse...");
    dataDirBrowse.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        dataDirBrowseActionPerformed(evt);
      }
    });

    optionsGroup.add(runAll);
    runAll.setSelected(true);
    runAll.setText("Run Entire Process");
    runAll.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
    runAll.setMargin(new java.awt.Insets(0, 0, 0, 0));
    runAll.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        runAllActionPerformed(evt);
      }
    });

    optionsGroup.add(importTaxMerge);
    importTaxMerge.setText("Start with Taxonomic Merge File");
    importTaxMerge.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
    importTaxMerge.setMargin(new java.awt.Insets(0, 0, 0, 0));
    importTaxMerge.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        importTaxMergeActionPerformed(evt);
      }
    });

    optionsGroup.add(importOpTax);
    importOpTax.setText("Start with Operational Taxonomy File");
    importOpTax.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
    importOpTax.setMargin(new java.awt.Insets(0, 0, 0, 0));
    importOpTax.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        importOpTaxActionPerformed(evt);
      }
    });

    coeffsLabel.setText("Coefficients File:");

    coeffs.setText("coefs.rda");

    coeffsBrowse.setText("Browse...");
    coeffsBrowse.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        coeffsBrowseActionPerformed(evt);
      }
    });

    bcntLabel.setText("Benthic Count File:");

    bcnt.setText("benthicCount.txt");

    bcntBrowse.setText("Browse...");
    bcntBrowse.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        bcntBrowseActionPerformed(evt);
      }
    });

    taxMergeLabel.setText("Taxonomic Merge File:");

    taxMerge.setText("taxMerge.txt");

    taxMergeBrowse.setText("Browse...");
    taxMergeBrowse.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        taxMergeBrowseActionPerformed(evt);
      }
    });

    opTaxLabel.setText("Operational Taxonomy File:");

    opTax.setText("OTU.txt");

    opTaxBrowse.setText("Browse...");
    opTaxBrowse.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        opTaxBrowseActionPerformed(evt);
      }
    });

    maxLikeLabel.setText("Maximum Likelihood File:");

    maxLike.setColumns(12);
    maxLike.setText("MaxLikEnv.txt");

    maxLikeBrowse.setText("Browse...");
    maxLikeBrowse.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        maxLikeBrowseActionPerformed(evt);
      }
    });

    cancelButton.setText("Cancel");
    cancelButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        cancelButtonActionPerformed(evt);
      }
    });

    submitButton.setText("Submit");
    submitButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        submitButtonActionPerformed(evt);
      }
    });

    helpButton.setText("Help");
    helpButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        helpButtonActionPerformed(evt);
      }
    });

    org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
    getContentPane().setLayout(layout);
    layout.setHorizontalGroup(
      layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
      .add(layout.createSequentialGroup()
        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
          .add(layout.createSequentialGroup()
            .add(12, 12, 12)
            .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
              .add(layout.createSequentialGroup()
                .add(12, 12, 12)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                  .add(runAll)
                  .add(importTaxMerge)
                  .add(importOpTax)))
              .add(layout.createSequentialGroup()
                .add(dataDirLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(dataDir, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 356, Short.MAX_VALUE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(dataDirBrowse))))
          .add(layout.createSequentialGroup()
            .addContainerGap()
            .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
              .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .add(maxLikeLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(maxLike, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 289, Short.MAX_VALUE))
              .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .add(opTaxLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(opTax, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 278, Short.MAX_VALUE))
              .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .add(taxMergeLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(taxMerge, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 310, Short.MAX_VALUE))
              .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .add(bcntLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(bcnt, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 332, Short.MAX_VALUE))
              .add(layout.createSequentialGroup()
                .add(coeffsLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(coeffs, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 345, Short.MAX_VALUE)))
            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
            .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING, false)
              .add(opTaxBrowse, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
              .add(maxLikeBrowse, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
              .add(bcntBrowse, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
              .add(coeffsBrowse, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
              .add(taxMergeBrowse))))
        .addContainerGap())
      .add(separator1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 580, Short.MAX_VALUE)
      .add(separator2, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 580, Short.MAX_VALUE)
      .add(layout.createSequentialGroup()
        .add(171, 171, 171)
        .add(cancelButton)
        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
        .add(submitButton)
        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
        .add(helpButton)
        .addContainerGap(182, Short.MAX_VALUE))
    );
    layout.setVerticalGroup(
      layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
      .add(layout.createSequentialGroup()
        .addContainerGap()
        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
          .add(dataDirLabel)
          .add(dataDirBrowse)
          .add(dataDir, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
        .add(runAll)
        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
        .add(importTaxMerge)
        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
        .add(importOpTax)
        .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
        .add(separator1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 8, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
          .add(coeffsLabel)
          .add(coeffsBrowse)
          .add(coeffs, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
          .add(bcntLabel)
          .add(bcnt, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
          .add(bcntBrowse))
        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
          .add(taxMergeLabel)
          .add(taxMerge, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
          .add(taxMergeBrowse))
        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
          .add(opTaxLabel)
          .add(opTax, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
          .add(opTaxBrowse))
        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
          .add(maxLikeLabel)
          .add(maxLike, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 19, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
          .add(maxLikeBrowse, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 25, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
        .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
        .add(separator2, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 10, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
          .add(submitButton)
          .add(cancelButton)
          .add(helpButton))
        .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
    );

    pack();
  }// </editor-fold>//GEN-END:initComponents

  private void taxMergeBrowseActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_taxMergeBrowseActionPerformed
  {//GEN-HEADEREND:event_taxMergeBrowseActionPerformed
    setTextUsingFileChooser(taxMerge, JFileChooser.FILES_ONLY);
  }//GEN-LAST:event_taxMergeBrowseActionPerformed

  private void maxLikeBrowseActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_maxLikeBrowseActionPerformed
  {//GEN-HEADEREND:event_maxLikeBrowseActionPerformed
    setTextUsingFileChooser(maxLike, JFileChooser.FILES_ONLY);
  }//GEN-LAST:event_maxLikeBrowseActionPerformed

  private void opTaxBrowseActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_opTaxBrowseActionPerformed
  {//GEN-HEADEREND:event_opTaxBrowseActionPerformed
    setTextUsingFileChooser(opTax, JFileChooser.FILES_ONLY);
  }//GEN-LAST:event_opTaxBrowseActionPerformed

  private void coeffsBrowseActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_coeffsBrowseActionPerformed
  {//GEN-HEADEREND:event_coeffsBrowseActionPerformed
    setTextUsingFileChooserStartInWorkspace(coeffs, JFileChooser.FILES_ONLY);
  }//GEN-LAST:event_coeffsBrowseActionPerformed

  private void bcntBrowseActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_bcntBrowseActionPerformed
  {//GEN-HEADEREND:event_bcntBrowseActionPerformed
    setTextUsingFileChooser(bcnt, JFileChooser.FILES_ONLY);
  }//GEN-LAST:event_bcntBrowseActionPerformed

  private void dataDirBrowseActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_dataDirBrowseActionPerformed
  {//GEN-HEADEREND:event_dataDirBrowseActionPerformed
    int fcReturnState = setTextUsingFileChooser(dataDir, JFileChooser.DIRECTORIES_ONLY);

    if (fcReturnState == JFileChooser.APPROVE_OPTION)
    {
      String dir = dataDir.getText();

      this.updateValidity();
    }
  }//GEN-LAST:event_dataDirBrowseActionPerformed

  private void importOpTaxActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_importOpTaxActionPerformed
  {//GEN-HEADEREND:event_importOpTaxActionPerformed
    this.updateValidity();
  }//GEN-LAST:event_importOpTaxActionPerformed

  private void importTaxMergeActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_importTaxMergeActionPerformed
  {//GEN-HEADEREND:event_importTaxMergeActionPerformed
    this.updateValidity();
  }//GEN-LAST:event_importTaxMergeActionPerformed

  private void runAllActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_runAllActionPerformed
  {//GEN-HEADEREND:event_runAllActionPerformed
    this.updateValidity();
  }//GEN-LAST:event_runAllActionPerformed

private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
  this.dispose();
}//GEN-LAST:event_cancelButtonActionPerformed

private void submitButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_submitButtonActionPerformed
  String maxLikePath = maxLike.getText().replace('\\', '/');
  maxLikePath = (maxLikePath.contains("/") ? "" : dataDir.getText() + "/") + maxLikePath;

  String cmd = "bioinfer1.JGR( "
          + "bencntFile=" + "'" + bcnt.getText().replace('\\', '/') + "'"
          + ", coefficientFile=" + "'" + coeffs.getText().replace('\\', '/') + "'"
          + ", runTaxonomic=" + String.valueOf(runAll.isSelected()).toUpperCase()
          + ", taxonomicFile=" + "'" + taxMerge.getText().replace('\\', '/') + "'"
          + ", runOTU=" + String.valueOf(runAll.isSelected()||importTaxMerge.isSelected()).toUpperCase()
          + ", otuFile=" + "'" + opTax.getText().replace('\\', '/') + "'"
          + ", mlFile=" + "'" + maxLikePath + "' )";
  JGR.MAINRCONSOLE.execute(cmd, true);
  this.dispose();
}//GEN-LAST:event_submitButtonActionPerformed

private void helpButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_helpButtonActionPerformed
  String cmd = "CADStat.help('bioinfer.JGR')";
  JGR.MAINRCONSOLE.execute(cmd, true);
//  JGR.MAINRCONSOLE.help("Speciestol");
}//GEN-LAST:event_helpButtonActionPerformed

  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JTextField bcnt;
  private javax.swing.JButton bcntBrowse;
  private javax.swing.JLabel bcntLabel;
  private javax.swing.JButton cancelButton;
  private javax.swing.JTextField coeffs;
  private javax.swing.JButton coeffsBrowse;
  private javax.swing.JLabel coeffsLabel;
  private javax.swing.JTextField dataDir;
  private javax.swing.JButton dataDirBrowse;
  private javax.swing.JLabel dataDirLabel;
  private javax.swing.JButton helpButton;
  private javax.swing.JRadioButton importOpTax;
  private javax.swing.JRadioButton importTaxMerge;
  private javax.swing.JTextField maxLike;
  private javax.swing.JButton maxLikeBrowse;
  private javax.swing.JLabel maxLikeLabel;
  private javax.swing.JTextField opTax;
  private javax.swing.JButton opTaxBrowse;
  private javax.swing.JLabel opTaxLabel;
  private javax.swing.ButtonGroup optionsGroup;
  private javax.swing.JRadioButton runAll;
  private javax.swing.JSeparator separator1;
  private javax.swing.JSeparator separator2;
  private javax.swing.JButton submitButton;
  private javax.swing.JTextField taxMerge;
  private javax.swing.JButton taxMergeBrowse;
  private javax.swing.JLabel taxMergeLabel;
  // End of variables declaration//GEN-END:variables

  @Override
  public void valueChanged(javax.swing.event.ListSelectionEvent listSelectionEvent)
  {
    this.updateValidity();
  }

  @Override
  public void insertUpdate(DocumentEvent documentEvent)
  {
    this.updateValidity();
  }

  @Override
  public void removeUpdate(DocumentEvent documentEvent)
  {
    this.updateValidity();
  }

  @Override
  public void changedUpdate(DocumentEvent documentEvent)
  {
    this.updateValidity();
  }

  protected void updateValidity()
  {
    //boolean isVarSelectionValid = varPane.getVarList2().getSelectedValue() != null;
    boolean isGlobalInputValid = isInputFileValid(coeffs.getText());
    boolean isGlobalOutputValid = isOutputFileValid(maxLike.getText());
    boolean isRunAllValid = runAll.isSelected()
      && isGlobalInputValid
      && isInputFileValid(bcnt.getText())
      && isGlobalOutputValid;
    boolean isImportTaxMergeValid = importTaxMerge.isSelected()
      && isGlobalInputValid
      && isInputFileValid(taxMerge.getText())
      && isGlobalOutputValid;
    boolean isImportOpTaxValid = importOpTax.isSelected()
      && isGlobalInputValid
      && isInputFileValid(opTax.getText())
      && isGlobalOutputValid;

    boolean enableSubmitButton = (isRunAllValid || isImportTaxMergeValid || isImportOpTaxValid);

    bcntLabel.setEnabled(runAll.isSelected());
    bcnt.setEnabled(runAll.isSelected());
    bcntBrowse.setEnabled(runAll.isSelected());

    taxMergeLabel.setEnabled(!importOpTax.isSelected());
    taxMerge.setEnabled(!importOpTax.isSelected());
    taxMergeBrowse.setEnabled(importTaxMerge.isSelected());

    //opTaxLabel.setEnabled(importOpTax.isSelected());
    //opTax.setEnabled(importOpTax.isSelected());
    opTaxBrowse.setEnabled(importOpTax.isSelected());

    submitButton.setEnabled(enableSubmitButton);
  }

  /**
   *  Uses File Chooser to set text of Text Field.
   *
   *  @param  textField   TextField whose text is to be set to the selected file path.
   *  @param  mode        File Chooser selection mode
   *
   *  @return File Chooser return state
   */
  private int setTextUsingFileChooser(JTextField textField, int mode)
  {
    JFileChooser fc = new JFileChooser(dataDir.getText());
    fc.setMultiSelectionEnabled(false);
    fc.setFileSelectionMode(mode);

    int fcReturnState = fc.showOpenDialog(this);

    if (fcReturnState == JFileChooser.APPROVE_OPTION)
    {
      textField.setText(fc.getSelectedFile().toString().replace('\\', '/'));
    }

    return fcReturnState;
  }

  private int setTextUsingFileChooserStartInWorkspace(JTextField textField, int mode)
  {
    JFileChooser fc = new JFileChooser(RUtils.evalAsString("file.path(R.home(),'library','CADStat','workspace','data')"));
    fc.setMultiSelectionEnabled(false);
    fc.setFileSelectionMode(mode);

    int fcReturnState = fc.showOpenDialog(this);

    if (fcReturnState == JFileChooser.APPROVE_OPTION)
    {
      textField.setText(fc.getSelectedFile().toString().replace('\\', '/'));
    }

    return fcReturnState;
  }

  /**
   *  Make sure that input file exists absolutely or exists in working directory.
   */
  private boolean isInputFileValid(String file)
  {
    File dataDirFile = new File(dataDir.getText());

    boolean isFileExists = new File(file).exists();
    boolean isFileExistsInDataDir = new File(dataDirFile, file).exists();

    return (isFileExists || isFileExistsInDataDir);
  }

  /**
   *  Make sure output file is specified.  It need not exist.
   */
  private boolean isOutputFileValid(String file)
  {
    return (file != null && file.trim().length() > 0);
  }

}
