/*
 * Decompiled with CFR 0.152.
 */
package org.neptuneinc.cadstat.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import org.neptuneinc.cadstat.ui.DatasetPane;
import org.neptuneinc.cadstat.ui.FactorSubsetPane;

public class DataPlotDialog
extends JDialog
implements WindowListener {
    private JPanel buttonPane;
    private JButton cancelButton;
    private JTabbedPane cardPane;
    private JPanel datasetCenteringPane;
    private DatasetPane datasetPane;
    private JPanel datasetParentPane;
    private JSeparator datasetSeparator;
    private JPanel factorPane;
    private FactorSubsetPane factorSelectionPane1;
    private FactorSubsetPane factorSelectionPane2;
    private JButton helpButton;
    private JPanel plotPane;
    private JButton submitButton;
    private JPanel subsetPane;

    public DataPlotDialog() {
        this.initComponents();
        this.initGeneral();
        this.initCustom();
    }

    protected void initGeneral() {
        this.getDatasetPane().getDatasetLabel().setText("Active Dataset:");
        this.getDatasetPane().getDatasetComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataPlotDialog.this.datasetComboBoxActionPerformed(e);
            }
        });
        this.addWindowListener(this);
        this.getFactorSelectionPane1().getFactorLabel().setText("Factor 1:");
        this.getFactorSelectionPane2().getFactorLabel().setText("Factor 2:");
        this.refreshFactorSelectionPanes();
        this.getRootPane().setDefaultButton(this.getSubmitButton());
        this.setDefaultCloseOperation(2);
    }

    private void datasetComboBoxActionPerformed(ActionEvent evt) {
        this.refreshFactorSelectionPanes();
    }

    public void refreshFactorSelectionPanes() {
        this.getFactorSelectionPane1().setDataset(this.getDatasetPane().getSelectedDataset());
        this.getFactorSelectionPane2().setDataset(this.getDatasetPane().getSelectedDataset());
        this.updateValidity();
    }

    protected void initCustom() {
    }

    private void updateValidity() {
        this.getCardPane().setEnabledAt(1, this.getFactorSelectionPane1().getFactorComboBox().getItemCount() > 0);
    }

    private void initComponents() {
        this.cardPane = new JTabbedPane();
        this.plotPane = new JPanel();
        this.datasetParentPane = new JPanel();
        this.datasetCenteringPane = new JPanel();
        this.datasetPane = new DatasetPane();
        this.datasetSeparator = new JSeparator();
        this.subsetPane = new JPanel();
        this.factorPane = new JPanel();
        this.factorSelectionPane1 = new FactorSubsetPane();
        this.factorSelectionPane2 = new FactorSubsetPane();
        this.buttonPane = new JPanel();
        this.cancelButton = new JButton();
        this.submitButton = new JButton();
        this.helpButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Scatterplot");
        this.plotPane.setLayout(new BorderLayout());
        this.datasetCenteringPane.add(this.datasetPane);
        GroupLayout datasetParentPaneLayout = new GroupLayout(this.datasetParentPane);
        this.datasetParentPane.setLayout(datasetParentPaneLayout);
        datasetParentPaneLayout.setHorizontalGroup(datasetParentPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.datasetCenteringPane, GroupLayout.Alignment.TRAILING, -1, 588, Short.MAX_VALUE).addComponent(this.datasetSeparator, -1, 588, Short.MAX_VALUE));
        datasetParentPaneLayout.setVerticalGroup(datasetParentPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(datasetParentPaneLayout.createSequentialGroup().addComponent(this.datasetCenteringPane, -2, -1, -2).addGap(8, 8, 8).addComponent(this.datasetSeparator, -2, -1, -2)));
        this.plotPane.add((Component)this.datasetParentPane, "North");
        this.cardPane.addTab("Main Options", this.plotPane);
        this.factorPane.setLayout(new GridLayout(1, 2, 20, 0));
        this.factorPane.add(this.factorSelectionPane1);
        this.factorPane.add(this.factorSelectionPane2);
        GroupLayout subsetPaneLayout = new GroupLayout(this.subsetPane);
        this.subsetPane.setLayout(subsetPaneLayout);
        subsetPaneLayout.setHorizontalGroup(subsetPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, subsetPaneLayout.createSequentialGroup().addContainerGap().addComponent(this.factorPane, -1, 564, Short.MAX_VALUE).addContainerGap()));
        subsetPaneLayout.setVerticalGroup(subsetPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(subsetPaneLayout.createSequentialGroup().addContainerGap().addComponent(this.factorPane, -1, 208, Short.MAX_VALUE).addContainerGap()));
        this.cardPane.addTab("Data Subsetting", this.subsetPane);
        this.getContentPane().add((Component)this.cardPane, "Center");
        this.buttonPane.setLayout(new FlowLayout(1, 10, 10));
        this.cancelButton.setText("Cancel");
        this.cancelButton.setMargin(new Insets(0, 10, 0, 10));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataPlotDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonPane.add(this.cancelButton);
        this.submitButton.setText("Submit");
        this.submitButton.setMargin(new Insets(0, 10, 0, 10));
        this.submitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataPlotDialog.this.submitButtonActionPerformed(evt);
            }
        });
        this.buttonPane.add(this.submitButton);
        this.helpButton.setText("Help");
        this.helpButton.setMargin(new Insets(0, 10, 0, 10));
        this.helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataPlotDialog.this.helpButtonActionPerformed(evt);
            }
        });
        this.buttonPane.add(this.helpButton);
        this.getContentPane().add((Component)this.buttonPane, "South");
        this.pack();
    }

    protected void helpButtonAction() {
    }

    private void helpButtonActionPerformed(ActionEvent evt) {
        this.helpButtonAction();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    protected void submitButtonAction() {
    }

    private void submitButtonActionPerformed(ActionEvent evt) {
        this.submitButtonAction();
    }

    protected JTabbedPane getCardPane() {
        return this.cardPane;
    }

    protected void setCardPane(JTabbedPane cardPane) {
        this.cardPane = cardPane;
    }

    protected JPanel getPlotPane() {
        return this.plotPane;
    }

    protected void setPlotPane(JPanel plotPane) {
        this.plotPane = plotPane;
    }

    public DatasetPane getDatasetPane() {
        return this.datasetPane;
    }

    public void setDatasetPane(DatasetPane datasetPane) {
        this.datasetPane = datasetPane;
    }

    public FactorSubsetPane getFactorSelectionPane1() {
        return this.factorSelectionPane1;
    }

    public void setFactorSelectionPane1(FactorSubsetPane factorSelectionPane1) {
        this.factorSelectionPane1 = factorSelectionPane1;
    }

    public FactorSubsetPane getFactorSelectionPane2() {
        return this.factorSelectionPane2;
    }

    public void setFactorSelectionPane2(FactorSubsetPane factorSelectionPane2) {
        this.factorSelectionPane2 = factorSelectionPane2;
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }

    public void setCancelButton(JButton cancelButton) {
        this.cancelButton = cancelButton;
    }

    public JButton getHelpButton() {
        return this.helpButton;
    }

    public void setHelpButton(JButton helpButton) {
        this.helpButton = helpButton;
    }

    public JButton getSubmitButton() {
        return this.submitButton;
    }

    public void setSubmitButton(JButton submitButton) {
        this.submitButton = submitButton;
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
        this.getDatasetPane().refreshDatasetComboBox();
        this.refreshFactorSelectionPanes();
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }
}

