/*
 * CorrelationAnalysis.java
 *
 * Created on September 20, 2005, 8:05 PM
 */
package org.neptuneinc.cadstat.plots;

import java.awt.BorderLayout;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;

import org.neptuneinc.cadstat.ui.DataPlotDialog;
import org.neptuneinc.cadstat.utils.GUIUtils;
import org.neptuneinc.cadstat.utils.RUtils;
import org.rosuda.JGR.JGR;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REngineException;
import CADStat.java.plots.SubsetFormatter;

/**
 *
 * @author  Pasha Minallah
 */
public class CorrelationAnalysis extends DataPlotDialog
{
  /**
   * Creates new form CorrelationAnalysis
   */
  public CorrelationAnalysis()
  {
    super();
  }

  /** Perform custom initialization. */
  @Override
  protected void initCustom()
  {
    this.initComponents();

    this.getPlotPane().add(plotPane, BorderLayout.CENTER);

    this.getDatasetPane().getDatasetComboBox().addActionListener(new ActionListener()
    {
      @Override
      public void actionPerformed(java.awt.event.ActionEvent evt)
      {
        datasetChangedAction();
      }
    });

    datasetChangedAction();

    confLevel.setModel(new SpinnerNumberModel(0.95, 0.01, 0.99, 0.01));

    updateValidity();
  }

  private void refreshVariableLists()
  {
    String dataset = this.getDatasetPane().getSelectedDataset();

    if (dataset != null)
    {
      Vector<String> nonFactors = null;

      try
      {
        nonFactors = RUtils.nonFactors(dataset);

        if (nonFactors != null)
        {
          colList2.setListData(nonFactors);
        }
        else
        {
          colList2.removeAll();
        }
      }
      catch (REngineException ex)
      {
        Logger.getLogger(CorrelationAnalysis.class.getName()).log(Level.SEVERE, null, ex);
      }
      catch (REXPMismatchException ex)
      {
        Logger.getLogger(CorrelationAnalysis.class.getName()).log(Level.SEVERE, null, ex);
      }
    }
  }

  public static Object[] getSelectedItems(JList list)
  {
    if (list != null)
    {
      return (list.getSelectedValues());
    }
    else
    {
      return (null);
    }
  }

  public Object[] getVariables()
  {
    return (getSelectedItems(colList2));
  }

  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the Form Editor.
   */
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {

    plotPane = new javax.swing.JPanel();
    varPane = new javax.swing.JPanel();
    varScrollPane = new javax.swing.JScrollPane();
    colList2 = new javax.swing.JList();
    analysisOptionsPane = new javax.swing.JPanel();
    scatterPlot = new javax.swing.JCheckBox();
    confIntervals = new javax.swing.JCheckBox();
    confLabel = new javax.swing.JLabel();
    confLevel = new javax.swing.JSpinner();
    methodPane = new javax.swing.JPanel();
    pearsonRadioButton = new javax.swing.JRadioButton();
    kendallRadioButton = new javax.swing.JRadioButton();
    spearmanRadioButton = new javax.swing.JRadioButton();
    methodGroup = new javax.swing.ButtonGroup();

    varPane.setBorder(javax.swing.BorderFactory.createTitledBorder("Variables"));

    varScrollPane.setPreferredSize(new java.awt.Dimension(100, 140));
    varScrollPane.setViewportView(colList2);

    javax.swing.GroupLayout varPaneLayout = new javax.swing.GroupLayout(varPane);
    varPane.setLayout(varPaneLayout);
    varPaneLayout.setHorizontalGroup(
      varPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(varPaneLayout.createSequentialGroup()
        .addContainerGap()
        .addComponent(varScrollPane, javax.swing.GroupLayout.DEFAULT_SIZE, 154, Short.MAX_VALUE)
        .addContainerGap())
    );
    varPaneLayout.setVerticalGroup(
      varPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, varPaneLayout.createSequentialGroup()
        .addContainerGap()
        .addComponent(varScrollPane, javax.swing.GroupLayout.DEFAULT_SIZE, 243, Short.MAX_VALUE)
        .addContainerGap())
    );

    analysisOptionsPane.setBorder(javax.swing.BorderFactory.createTitledBorder("Analysis Options"));

    scatterPlot.setText("Create Scatterplot Matrix");

    confIntervals.setText("Compute Confidence Intervals");
    confIntervals.addChangeListener(new javax.swing.event.ChangeListener() {
      public void stateChanged(javax.swing.event.ChangeEvent evt) {
        confIntervalsStateChanged(evt);
      }
    });

    confLabel.setText("Confidence Level:");

    javax.swing.GroupLayout analysisOptionsPaneLayout = new javax.swing.GroupLayout(analysisOptionsPane);
    analysisOptionsPane.setLayout(analysisOptionsPaneLayout);
    analysisOptionsPaneLayout.setHorizontalGroup(
      analysisOptionsPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(analysisOptionsPaneLayout.createSequentialGroup()
        .addContainerGap()
        .addComponent(confIntervals)
        .addContainerGap(16, Short.MAX_VALUE))
      .addGroup(analysisOptionsPaneLayout.createSequentialGroup()
        .addContainerGap()
        .addComponent(scatterPlot)
        .addContainerGap(59, Short.MAX_VALUE))
      .addGroup(analysisOptionsPaneLayout.createSequentialGroup()
        .addGap(58, 58, 58)
        .addComponent(confLabel)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(confLevel, javax.swing.GroupLayout.DEFAULT_SIZE, 80, Short.MAX_VALUE)
        .addContainerGap())
    );
    analysisOptionsPaneLayout.setVerticalGroup(
      analysisOptionsPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(analysisOptionsPaneLayout.createSequentialGroup()
        .addContainerGap()
        .addComponent(scatterPlot)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(confIntervals)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addGroup(analysisOptionsPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
          .addComponent(confLabel)
          .addComponent(confLevel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        .addContainerGap())
    );

    methodPane.setBorder(javax.swing.BorderFactory.createTitledBorder("Method"));

    methodGroup.add(pearsonRadioButton);
    pearsonRadioButton.setSelected(true);
    pearsonRadioButton.setText("Pearson");
    pearsonRadioButton.addChangeListener(new javax.swing.event.ChangeListener() {
      public void stateChanged(javax.swing.event.ChangeEvent evt) {
        pearsonRadioButtonStateChanged(evt);
      }
    });

    methodGroup.add(kendallRadioButton);
    kendallRadioButton.setText("Kendall");
    kendallRadioButton.addChangeListener(new javax.swing.event.ChangeListener() {
      public void stateChanged(javax.swing.event.ChangeEvent evt) {
        kendallRadioButtonStateChanged(evt);
      }
    });

    methodGroup.add(spearmanRadioButton);
    spearmanRadioButton.setText("Spearman");
    spearmanRadioButton.addChangeListener(new javax.swing.event.ChangeListener() {
      public void stateChanged(javax.swing.event.ChangeEvent evt) {
        spearmanRadioButtonStateChanged(evt);
      }
    });

    javax.swing.GroupLayout methodPaneLayout = new javax.swing.GroupLayout(methodPane);
    methodPane.setLayout(methodPaneLayout);
    methodPaneLayout.setHorizontalGroup(
      methodPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(methodPaneLayout.createSequentialGroup()
        .addGroup(methodPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addGroup(methodPaneLayout.createSequentialGroup()
            .addContainerGap()
            .addComponent(pearsonRadioButton))
          .addGroup(methodPaneLayout.createSequentialGroup()
            .addContainerGap()
            .addComponent(kendallRadioButton))
          .addGroup(methodPaneLayout.createSequentialGroup()
            .addContainerGap()
            .addComponent(spearmanRadioButton)))
        .addContainerGap(196, Short.MAX_VALUE))
    );
    methodPaneLayout.setVerticalGroup(
      methodPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(methodPaneLayout.createSequentialGroup()
        .addContainerGap()
        .addComponent(pearsonRadioButton)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(kendallRadioButton)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(spearmanRadioButton)
        .addContainerGap())
    );

    javax.swing.GroupLayout plotPaneLayout = new javax.swing.GroupLayout(plotPane);
    plotPane.setLayout(plotPaneLayout);
    plotPaneLayout.setHorizontalGroup(
      plotPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(plotPaneLayout.createSequentialGroup()
        .addContainerGap()
        .addComponent(varPane, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addGroup(plotPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
          .addComponent(analysisOptionsPane, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
          .addComponent(methodPane, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
    );
    plotPaneLayout.setVerticalGroup(
      plotPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(plotPaneLayout.createSequentialGroup()
        .addContainerGap()
        .addGroup(plotPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
          .addComponent(varPane, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
          .addGroup(javax.swing.GroupLayout.Alignment.LEADING, plotPaneLayout.createSequentialGroup()
            .addComponent(methodPane, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(analysisOptionsPane, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
        .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
    );

    setTitle("Correlation Analysis");

    java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
    setBounds((screenSize.width-584)/2, (screenSize.height-522)/2, 584, 522);
  }// </editor-fold>//GEN-END:initComponents

  private void confIntervalsStateChanged(javax.swing.event.ChangeEvent evt)//GEN-FIRST:event_confIntervalsStateChanged
  {//GEN-HEADEREND:event_confIntervalsStateChanged
    updateValidity();
  }//GEN-LAST:event_confIntervalsStateChanged

  private void pearsonRadioButtonStateChanged(javax.swing.event.ChangeEvent evt)//GEN-FIRST:event_pearsonRadioButtonStateChanged
  {//GEN-HEADEREND:event_pearsonRadioButtonStateChanged
    processMethodChange();
  }//GEN-LAST:event_pearsonRadioButtonStateChanged

  private void kendallRadioButtonStateChanged(javax.swing.event.ChangeEvent evt)//GEN-FIRST:event_kendallRadioButtonStateChanged
  {//GEN-HEADEREND:event_kendallRadioButtonStateChanged
    processMethodChange();
  }//GEN-LAST:event_kendallRadioButtonStateChanged

  private void spearmanRadioButtonStateChanged(javax.swing.event.ChangeEvent evt)//GEN-FIRST:event_spearmanRadioButtonStateChanged
  {//GEN-HEADEREND:event_spearmanRadioButtonStateChanged
    processMethodChange();
  }//GEN-LAST:event_spearmanRadioButtonStateChanged

  private void processMethodChange()
  {
    boolean enableConfControls = pearsonRadioButton.isSelected();

    confIntervals.setEnabled(enableConfControls);
    confLabel.setEnabled(enableConfControls);
    confLevel.setEnabled(enableConfControls);
  }

  private void updateValidity()
  {
    boolean enableConfLevel = confIntervals.isSelected();

    confLabel.setEnabled(enableConfLevel);
    confLevel.setEnabled(enableConfLevel);
  }

  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JPanel analysisOptionsPane;
  private javax.swing.JList colList2;
  private javax.swing.JCheckBox confIntervals;
  private javax.swing.JLabel confLabel;
  private javax.swing.JSpinner confLevel;
  private javax.swing.JRadioButton kendallRadioButton;
  private javax.swing.ButtonGroup methodGroup;
  private javax.swing.JPanel methodPane;
  private javax.swing.JRadioButton pearsonRadioButton;
  private javax.swing.JPanel plotPane;
  private javax.swing.JCheckBox scatterPlot;
  private javax.swing.JRadioButton spearmanRadioButton;
  private javax.swing.JPanel varPane;
  private javax.swing.JScrollPane varScrollPane;
  // End of variables declaration//GEN-END:variables

  private List getColumn(JTable table, int column)
  {
    if (table != null && column <= table.getColumnCount())
    {
      List list = new ArrayList();

      for (int i = 0, n = table.getRowCount(); i < n; ++i)
      {
        list.add(table.getValueAt(i, column));
      }

      return (list);
    }
    else
    {
      return (null);
    }
  }

  @Override
  protected void submitButtonAction()
  {
    String method = null;

    if (pearsonRadioButton.isSelected())
    {
      method = "pearson";
    }
    else if (kendallRadioButton.isSelected())
    {
      method = "kendall";
    }
    else if (spearmanRadioButton.isSelected())
    {
      method = "spearman";
    }

    String cmd = "cor.JGR("
      + "my.data=" + this.getDatasetPane().getSelectedDataset()
      + ", subset1.name=" + (this.getFactorSelectionPane1().getFactorValueList().isSelectionEmpty() ? "NULL" : "'" + this.getFactorSelectionPane1().getSelectedFactor() + "'")
      + ", subset1.val=" + (this.getFactorSelectionPane1().getFactorValueList().isSelectionEmpty() ? "NULL" : SubsetFormatter.formatSubset(this.getFactorSelectionPane1().getSelectedFactorValues()))
      + ", subset2.name=" + (this.getFactorSelectionPane2().getFactorValueList().isSelectionEmpty() ? "NULL" : "'" + this.getFactorSelectionPane2().getSelectedFactor() + "'")
      + ", subset2.val=" + (this.getFactorSelectionPane2().getFactorValueList().isSelectionEmpty() ? "NULL" : SubsetFormatter.formatSubset(this.getFactorSelectionPane2().getSelectedFactorValues()))
      + ", my.vars=" + (this.getVariables() != null && this.getVariables().length > 0 ? "c(" + RUtils.toString(getVariables(), ",", "'") + ")" : "NULL")
      + ", iMethod=" + RUtils.getStringValue(method)
      + ", iCI=" + GUIUtils.getBooleanValueR(confIntervals)
      + ", conf.level=" + (confIntervals.isSelected() ? ((Double) confLevel.getValue()).doubleValue() : "NULL")
      + ", iScatterplot=" + GUIUtils.getBooleanValueR(scatterPlot)
      + ")";
    JGR.MAINRCONSOLE.execute(cmd, true);
  }

  @Override
  protected void helpButtonAction()
  {
    String cmd = "CADStat.help('cor.JGR')";
    JGR.MAINRCONSOLE.execute(cmd, true);
    //JGR.MAINRCONSOLE.help("CorrelationAnalysis");
  }

  protected void datasetChangedAction()
  {
    refreshVariableLists();
  }

  @Override
  public void windowActivated(WindowEvent e)
  {
    int[] varIndices = colList2.getSelectedIndices();

    this.getDatasetPane().refreshDatasetComboBox();
    this.refreshFactorSelectionPanes();

    colList2.setSelectedIndices(varIndices);
  }
}
