% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/caesar_image.R
\name{cellembedding_image_seurat}
\alias{cellembedding_image_seurat}
\title{Compute Spatial-Aware Cell Embeddings with Image Information}
\usage{
cellembedding_image_seurat(
  seu,
  adjm,
  assay = NULL,
  slot = "data",
  q = 10,
  approx_Phi = FALSE,
  reduction.name = "caesar",
  var.features = NULL,
  ...
)
}
\arguments{
\item{seu}{A Seurat object containing gene expression data. The object should have variable features identified prior to running this function.}

\item{adjm}{A spatial adjacency matrix representing relationships between cells or spots.}

\item{assay}{A character string specifying which assay to use from the Seurat object. If NULL, the function will use the default assay set in the Seurat object.}

\item{slot}{The data slot to use for feature extraction (e.g., "data", "scale.data"). Default is "data".}

\item{q}{An integer specifying the number of dimensions for the reduced embeddings. Default is 10.}

\item{approx_Phi}{Logical, indicating whether to use an approximate method for estimating the Phi matrix. Default is FALSE.}

\item{reduction.name}{A character string specifying the name for the dimensional reduction result. Default is "caesar".}

\item{var.features}{A vector of variable features (genes) to use for the analysis. If NULL, the function will automatically use the variable features stored in the Seurat object.}

\item{...}{Additional arguments passed to `cellembedding_image_matrix`.}
}
\value{
The modified Seurat object with the cell embedding results stored in the specified dimensional reduction slot.
}
\description{
This function computes low-dimensional cell embeddings from a seyrat object. The method initializes cell embeddings using approximate PCA and refines them through a linear factor model nested a intrinsical conditional autoregressive model.
}
\seealso{
\code{\link{cellembedding_image_matrix}} for additional arguments used to compute cell embeddings.
}
