#' One-step population size estimate for low sample coverage cases.
#' @param z 
#' @return population size estimator

estN.LSC=function(z){
	if(length(z)==7){
		z001=z[1];	z010=z[2];	z011=z[3];	z100=z[4];	z101=z[5];	z110=z[6];	z111=z[7]
		n1=z100+z101+z110+z111
		n2=z010+z011+z110+z111
		n3=z001+z011+z101+z111
		chat=1-(1/3)*(z100/n1+z010/n2+z001/n3)
		d=(1/3)*(z100+z101+z010+z011+z110+z111
					+z100+z110+z001+z011+z101+z111
					+z010+z110+z001+z101+z011+z111)
		n0=d/chat
		n=n0+((z100+z110+z010+z110)*(n0*(z110+z111)/(n1*n2)-1)
					+(z100+z101+z001+z101)*(n0*(z101+z111)/(n1*n3)-1)
					+(z010+z011+z001+z011)*(n0*(z011+z111)/(n2*n3)-1))/(3*chat)
		r12=n*(z110+z111)/(n1*n2)-1
		r13=n*(z101+z111)/(n1*n3)-1
		r23=n*(z011+z111)/(n2*n3)-1
		y=((z100+z110+z010+z110)*r12+(z100+z101+z001+z101)*r13+(z010+z011+z001+z011)*r23)
		nhat1=d/chat+1/(3*chat)*y
		nhat1
	}
	else if(length(z)==15){
		z0001=z[1];	z0010=z[2]; z0011=z[3]; z0100=z[4]; z0101=z[5];
		z0110=z[6]; z0111=z[7]; z1000=z[8]; z1001=z[9]; z1010=z[10];
		z1011=z[11]; z1100=z[12]; z1101=z[13]; z1110=z[14]; z1111=z[15]
		
		n1=z1000+z1001+z1010+z1100+z1011+z1110+z1101+z1111
		n2=z0100+z0101+z0110+z0111+z1100+z1110+z1101+z1111
		n3=z0010+z0011+z0110+z0111+z1010+z1011+z1110+z1111
		n4=z0001+z0011+z0101+z0111+z1001+z1011+z1101+z1111
		chat=1-(1/4)*(z1000/n1+z0100/n2+z0010/n3+z0001/n4)
		d=(1/4)*(z1000+z1001+z1010+z1011+z1100+z1101+z0100+z0101+z0110+z0111+z0010+z0011+z1110+z1111  
					+z1000+z1010+z1001+z1011+z1100+z1110+z0001+z0011+z0101+z0111+z0100+z0110+z1101+z1111
					+z1000+z1100+z1001+z1101+z1010+z1110+z0001+z0101+z0010+z0110+z0011+z0111+z1011+z1111
					+z0001+z1001+z0010+z1010+z0011+z1011+z0100+z1100+z0101+z1101+z0110+z1110+z0111+z1111)			
		
		n0=d/chat
		n=n0+((z1000+z1100+z0100+z1100)*(n0*(z1100+z1101+z1110+z1111)/(n1*n2)-1)
					+(z1000+z1010+z0010+z1010)*(n0*(z1010+z1011+z1110+z1111)/(n1*n3)-1)
					+(z1000+z1001+z0001+z1001)*(n0*(z1001+z1011+z1101+z1111)/(n1*n4)-1)
					+(z0100+z0110+z0010+z0110)*(n0*(z0110+z0111+z1110+z1111)/(n2*n3)-1)
					+(z0100+z0101+z0001+z0101)*(n0*(z0101+z0111+z1101+z1111)/(n2*n4)-1)
					+(z0010+z0011+z0001+z0011)*(n0*(z0011+z0111+z1011+z1111)/(n3*n4)-1))/(4*chat)
		
		r12=n*(z1100+z1101+z1110+z1111)/(n1*n2)-1                                          
		r13=n*(z1010+z1011+z1110+z1111)/(n1*n3)-1
		r14=n*(z1001+z1011+z1101+z1111)/(n1*n4)-1
		r23=n*(z0110+z0111+z1110+z1111)/(n2*n3)-1
		r24=n*(z0101+z0111+z1101+z1111)/(n2*n4)-1
		r34=n*(z0011+z0111+z1011+z1111)/(n3*n4)-1
		y=((z1000+z1100+z0100+z1100)*r12+(z1000+z1010+z0010+z1010)*r13+(z1000+z1001+z0001+z1001)*r14
					+(z0100+z0110+z0010+z0110)*r23+(z0100+z0101+z0001+z0101)*r24+(z0010+z0011+z0001+z0011)*r34)
		nhat1=d/chat+1/(4*chat)*y
		nhat1
	}
	else if(length(z)==31){
		z00001=z[1]; z00010=z[2]; z00011=z[3]; z00100=z[4];
		z00101=z[5]; z00110=z[6]; z00111=z[7]; z01000=z[8]; 
		z01001=z[9]; z01010=z[10]; z01011=z[11]; z01100=z[12];
		z01101=z[13]; z01110=z[14]; z01111=z[15]; z10000=z[16]; 
		z10001=z[17]; z10010=z[18]; z10011=z[19]; z10100=z[20];
		z10101=z[21]; z10110=z[22]; z10111=z[23]; z11000=z[24];
		z11001=z[25]; z11010=z[26]; z11011=z[27]; z11100=z[28];
		z11101=z[29]; z11110=z[30]; z11111=z[31]
		
		n1=z10000+z10001+z10010+z10011+z10100+z10101+z10110+z10111+z11000+z11001+z11010+z11011+z11100+z11101+z11110+z11111
		n2=z01000+z01001+z01010+z01011+z01100+z01101+z01110+z01111+z11000+z11001+z11010+z11011+z11100+z11101+z11110+z11111
		n3=z00100+z00101+z00110+z00111+z01100+z01101+z01110+z01111+z10100+z10101+z10110+z10111+z11100+z11101+z11110+z11111
		n4=z00010+z00011+z00110+z00111+z01010+z01011+z01110+z01111+z10010+z10011+z10110+z10111+z11010+z11011+z11110+z11111
		n5=z00001+z00011+z00101+z00111+z01001+z01011+z01101+z01111+z10001+z10011+z10101+z10111+z11001+z11011+z11101+z11111
		chat=1-(1/5)*(z10000/n1+z01000/n2+z00100/n3+z00010/n4+z00001/n5)
		
		d=(1/5)*(z00010+z00011+z00100+z00101+z00110+z00111+z01000+z01001+z01010+z01011+z01100+z01101
					+z01110+z01111+z10000+z10001+z10010+z10011+z10100+z10101+z10110+z10111+z11000+z11001
					+z11010+z11011+z11100+z11101+z11110+z11111
					+z00001+z00011+z00100+z00110+z00101+z00111+z01000+z01010+z01001+z01011+z01100+z01110
					+z01101+z01111+z10000+z10010+z10001+z10011+z10100+z10110+z10101+z10111+z11000+z11010
					+z11001+z11011+z11100+z11110+z11101+z11111
					+z00001+z00101+z00010+z00110+z00011+z00111+z01000+z01100+z01001+z01101+z01010+z01110
					+z01011+z01111+z10000+z10100+z10001+z10101+z10010+z10110+z10011+z10111+z11000+z11100
					+z11001+z11101+z11010+z11110+z11011+z11111
					+z00001+z01001+z00010+z01010+z00011+z01011+z00100+z01100+z00101+z01101+z00110+z01110
					+z00111+z01111+z10000+z11000+z10001+z11001+z10010+z11010+z10011+z11011+z10100+z11100
					+z10101+z11101+z10110+z11110+z10111+z11111
					+z00001+z10001+z00010+z10010+z00011+z10011+z00100+z10100+z00101+z10101+z00110+z10110
					+z00111+z10111+z01000+z11000+z01001+z11001+z01010+z11010+z01011+z11011+z01100+z11100
					+z01101+z11101+z01110+z11110+z01111+z11111)
		
		n0=d/chat
		n=n0+((z10000+z11000+z01000+z11000)*(n0*(z11000+z11001+z11010+z11011+z11100+z11101+z11110+z11111)/(n1*n2)-1)
					+(z10000+z10100+z00100+z10100)*(n0*(z10100+z10101+z10110+z10111+z11100+z11101+z11110+z11111)/(n1*n3)-1)
					+(z10000+z10010+z00010+z10010)*(n0*(z10010+z10011+z10110+z10111+z11011+z11010+z11110+z11111)/(n1*n4)-1)
					+(z10000+z10001+z00001+z10001)*(n0*(z10001+z10011+z10101+z10111+z11001+z11011+z11101+z11111)/(n1*n5)-1)
					+(z01000+z01100+z00100+z01100)*(n0*(z01100+z01101+z01110+z01111+z11100+z11101+z11110+z11111)/(n2*n3)-1)
					+(z01000+z01010+z00010+z01010)*(n0*(z01010+z01011+z01110+z01111+z11010+z11011+z11110+z11111)/(n2*n4)-1)
					+(z01000+z01001+z00001+z01001)*(n0*(z01001+z01011+z01101+z01111+z11001+z11011+z11101+z11111)/(n2*n5)-1)
					+(z00100+z00110+z00010+z00110)*(n0*(z00110+z00111+z01110+z01111+z10110+z10111+z11110+z11111)/(n3*n4)-1)
					+(z00100+z00101+z00001+z00101)*(n0*(z00101+z00111+z01101+z01111+z10101+z10111+z11101+z11111)/(n3*n5)-1)
					+(z00010+z00011+z00001+z00011)*(n0*(z00011+z00111+z01011+z01111+z10011+z10111+z11011+z11111)/(n4*n5)-1))/(5*chat)
		
		r12=n*(z11000+z11001+z11010+z11011+z11100+z11101+z11110+z11111)/(n1*n2)-1                                        
		r13=n*(z10100+z10101+z10110+z10111+z11100+z11101+z11110+z11111)/(n1*n3)-1
		r14=n*(z10010+z10011+z10110+z10111+z11011+z11010+z11110+z11111)/(n1*n4)-1
		r15=n*(z10001+z10011+z10101+z10111+z11001+z11011+z11101+z11111)/(n1*n5)-1
		r23=n*(z01100+z01101+z01110+z01111+z11100+z11101+z11110+z11111)/(n2*n3)-1
		r24=n*(z01010+z01011+z01110+z01111+z11010+z11011+z11110+z11111)/(n2*n4)-1
		r25=n*(z01001+z01011+z01101+z01111+z11001+z11011+z11101+z11111)/(n2*n5)-1
		r34=n*(z00110+z00111+z01110+z01111+z10110+z10111+z11110+z11111)/(n3*n4)-1
		r35=n*(z00101+z00111+z01101+z01111+z10101+z10111+z11101+z11111)/(n3*n5)-1
		r45=n*(z00011+z00111+z01011+z01111+z10011+z10111+z11011+z11111)/(n4*n5)-1
		
		y=((z10000+z11000+z01000+z11000)*r12+(z10000+z10100+z00100+z10100)*r13
					+(z10000+z10010+z00010+z10010)*r14+(z10000+z10001+z00001+z10001)*r15
					+(z01000+z01100+z00100+z01100)*r23+(z01000+z01010+z00010+z01010)*r24
					+(z01000+z01001+z00001+z01001)*r25+(z00100+z00110+z00010+z00110)*r34
					+(z00100+z00101+z00001+z00101)*r35+(z00010+z00011+z00001+z00011)*r45)
		
		nhat1=d/chat+1/(5*chat)*y
		nhat1
	}
	else
		"Invalid argument error! Please input valid ascertainment records."
}