% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/carrot_functions.R
\name{compute_max_length}
\alias{compute_max_length}
\title{Maximum number of the regressions}
\usage{
compute_max_length(vari_col,k,c,we,maxx,st)
}
\arguments{
\item{vari_col}{number of predictors}

\item{k}{maximum weight of the predictors}

\item{c}{array of all indices of the predictors}

\item{we}{array of weights of the predictors. Continuous or categorical numerical variable with more then 5 categories has weight 1, otherwise it has weight \code{n-1} where \code{n} is the number of categories}

\item{maxx}{maximum number of predictors, total number of variables by default}

\item{st}{a subset of predictors to be always included into a predictive model,defaults to empty set}
}
\value{
Integer correponding to maximum number of regressions of the same size
}
\description{
Function which computes the maximum number of regressions with fixed number of variables based on the rule of thumb
}
\examples{
compute_max_length(4,40,1:4,c(1,1,2,1))
}
\references{
{
\insertRef{ref1}{CARRoT}
}

{
\insertRef{ref2012-18631-001}{CARRoT}
}
}
\seealso{
Function uses \code{\link[utils]{combn}}
}
