% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CAR-LASSO.R
\name{bGlasso}
\alias{bGlasso}
\title{Gibbs sampler for Bayesian Graphical LASSO and extensions}
\usage{
bGlasso(
  data,
  link = "identity",
  r_Omega = 1,
  delta_Omega = 0.01,
  n_iter = 2000,
  n_burn_in = 1000,
  thin_by = 10,
  ns = 1000,
  m = 20,
  emax = 64,
  progress = TRUE,
  verbos = TRUE
)
}
\arguments{
\item{data}{A data.frame with all response, row as observations}

\item{link}{String name of link function? Currently can be "identity" for normal response, "probit" for binary, "log" for counting, "logit" for compositional. Note that when use "logit", the last response will be used as reference.}

\item{r_Omega}{Hyper-parameter for precision matrix, shape parameter of Gamma. Should be a scalar}

\item{delta_Omega}{Hyper-parameter for precision matrix, rate parameter of Gamma. Shoule be a scalar}

\item{n_iter}{Number of sampling iterations (i.e. after burn in) for the Gibbs sampler}

\item{n_burn_in}{Number of burn in iterations for the Gibbs sampler}

\item{thin_by}{Final sample was thin by this number}

\item{ns}{parameter for ARS, maximum number of hulls, only used when link is "log" and "logit"}

\item{m}{parameter for ARS, initial number of hulls, only used when link is "log" and "logit"}

\item{emax}{parameter for ARS, tolerance for small values being 0, larger meaning we tolerate smaller values, only used when link is "log" and "logit"}

\item{progress}{Bool, whether report progress from C++}

\item{verbos}{Bool, whether show warnings and messages.}
}
\value{
A \code{bglasso_out} object with elements:
\itemize{
\item{\verb{$point_est}}{
\itemize{
\item{\verb{$Omega}}{: Posterior mean of precision matrix}
}
}
\item{\verb{$nodes}}{
\itemize{
\item{\verb{$responses}}{: node name of responses}
}
}

\item{\verb{$data}}{
\itemize{
\item{\verb{$response}}{: response matrix}
}
}

\item{\verb{$settings}}{: all settings sent to the algorithm, exclude data}
\item{\verb{$MCMC_output}}{
\itemize{
\item{\verb{$mu}}{: A coda::mcmc object, each row was an MCMC sample of the mean vector}
\item{\verb{$Omega}}{: A coda::mcmc object, each row was an MCMC sample of the upper triangular part (with diagonal) of precision matrix Omega}
\item{\verb{$lambda}}{:  A coda::mcmc object, first column was the shrinkage parameter lambda for regression coefficient and the second column was shrinkage parameter lambda for precision matrix}
}
}
}
}
\description{
Main sampling algorithm of Glasso model, note that the mean is in CAR parameterization
}
\examples{
set.seed(42)
dt <- simu_AR1()
glassores <- bGlasso(data = dt[,1:5])
plot(glassores) 

}
