% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.R
\name{create_Polys}
\alias{create_Polys}
\title{Create Polygons}
\usage{
create_Polys(
  Input,
  OutputFormat = "ROBJECT",
  OutputName = NULL,
  Buffer = 0,
  Densify = TRUE,
  Clip = FALSE,
  SeparateBuf = TRUE
)
}
\arguments{
\item{Input}{the name of the \code{Input} data as a .csv file or an R dataframe.
If a .csv file is used as input, this file must be in your working directory and its name given in quotes
e.g. "DataFile.csv".

\strong{The columns in the \code{Input} must be in the following order:

Polygon name, Latitude, Longitude.

Latitudes and Longitudes must be given clockwise.}}

\item{OutputFormat}{can be an R object or an ESRI Shapefile. if \code{OutputFormat} is specified as
"ROBJECT" (the default), a SpatialPolygonDataFrame is created in your R environment.
if \code{OutputFormat} is specified as "SHAPEFILE", an ESRI Shapefile is exported in
your working directory.}

\item{OutputName}{if \code{OutputFormat} is specified as "SHAPEFILE", the name of the output
shapefile in quotes (e.g. "MyPolygons") must be provided.}

\item{Buffer}{Distance in nautical miles by which to expand the polygons. Can be specified for
each polygon (as a numeric vector).}

\item{Densify}{If set to TRUE, additional points between points of equal latitude are added
prior to projection (see examples).}

\item{Clip}{if set to TRUE, polygon parts that fall on land are removed (see \link{Clip2Coast}).}

\item{SeparateBuf}{If set to FALSE when adding a \code{Buffer},
all spatial objects are merged, resulting in a single spatial object.}
}
\value{
Spatial object in your environment or ESRI shapefile in your working directory.
Data within the resulting spatial object contains the data provided in the \code{Input} plus
and additional "AreaKm2" column which corresponds to the areas, in square kilometers, of your polygons.
Also, columns "Labx" and "Laby" may be used to add labels to polygons.

To see the data contained in your spatial object, type: \code{View(MyPolygons@data)}.
}
\description{
Create Polygons such as proposed Research Blocks or Marine Protected Areas.
}
\examples{
\donttest{


#Example 1: Simple and non-densified polygons

MyPolys=create_Polys(PolyData,Densify=FALSE)
plot(MyPolys,col='blue')
text(MyPolys$Labx,MyPolys$Laby,MyPolys$ID,col='white')

#Example 2: Simple and densified polygons (note the curvature of iso-latitude lines)

MyPolys=create_Polys(PolyData)
plot(MyPolys,col='red')
text(MyPolys$Labx,MyPolys$Laby,MyPolys$ID,col='white')

#Example 3: Buffered and clipped polygons

MyPolysBefore=create_Polys(PolyData,Buffer=c(10,-15,120))
MyPolysAfter=create_Polys(PolyData,Buffer=c(10,-15,120),Clip=TRUE)
plot(MyPolysBefore,col='green')
plot(Coast[Coast$ID=='All',],add=TRUE)
plot(MyPolysAfter,col='red',add=TRUE)
text(MyPolysAfter$Labx,MyPolysAfter$Laby,MyPolysAfter$ID,col='white')

#Example 4: Buffered and grouped polygons
MyPolys=create_Polys(PolyData,Buffer=80,SeparateBuf=FALSE)
plot(MyPolys,border='blue',lwd=3)


}

}
\seealso{
\code{\link{create_Points}}, \code{\link{create_Lines}}, \code{\link{create_PolyGrids}},
\code{\link{create_Stations}}, \code{\link{add_RefGrid}}.
}
