% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load.R
\name{load_ASDs}
\alias{load_ASDs}
\title{Load CCAMLR statistical Areas, Subareas and Divisions}
\usage{
load_ASDs()
}
\description{
Download the up-to-date spatial layer from the online CCAMLRGIS (\url{http://gis.ccamlr.org/}) and load it to your environment.
See examples for offline use. All layers use the Lambert azimuthal equal-area projection
 (\code{\link{CCAMLRp}})
}
\examples{
 
\donttest{

#When online:
ASDs=load_ASDs()
plot(st_geometry(ASDs))

#If going offline in the future: load and save as RData when online,
#then reload RData when offline:
ASDs=load_ASDs()
EEZs=load_EEZs()
#N.B.: replace tempdir() with folder location of your choice
save(list=c('ASDs','EEZs'), file = file.path(tempdir(), "CCAMLRLayers.RData"))
rm(ASDs,EEZs)
load(file.path(tempdir(), "CCAMLRLayers.RData"))

}
}
\seealso{
\code{\link{load_SSRUs}}, \code{\link{load_RBs}},
\code{\link{load_SSMUs}}, \code{\link{load_MAs}}, \code{\link{load_Coastline}},
\code{\link{load_MPAs}}, \code{\link{load_EEZs}}.
}
