% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QQplot.R
\name{QQplot}
\alias{QQplot}
\title{QQ-plot for multiple testing in CCI}
\usage{
QQplot(
  object,
  axis.text.x = 17,
  axis.text.y = 17,
  strip.text.x = 17,
  strip.text.y = 17,
  legend.text = 17,
  legend.title = 17,
  ...
)
}
\arguments{
\item{object}{Object of class 'CCI'}

\item{axis.text.x}{Size of x-axis text}

\item{axis.text.y}{Size of y-axis text}

\item{strip.text.x}{Size of x-axis strip text}

\item{strip.text.y}{Size of y-axis strip text}

\item{legend.text}{Size of legend text}

\item{legend.title}{Size of legend title}

\item{...}{Additional arguments to pass to the \code{test.gen} function.}
}
\value{
A QQ-plot of the p-values in ggplot2 format.
}
\description{
QQ-plot for multiple testing in CCI
}
\examples{
dat <- data.frame(x1 = rnorm(100), x2 = rnorm(100), y = rnorm(100))
cci <- CCI.test(y ~ x1 | x2,
data = dat,
nperm = 25,
interaction = FALSE)
QQplot(cci)
}
\seealso{
\code{\link{print.CCI}}, \code{\link{summary.CCI}},
\code{\link{plot.CCI}}, \code{\link{perm.test}}
}
