% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CCI.test.R
\name{CCI.test}
\alias{CCI.test}
\alias{CCI}
\title{Computational test for conditional independence based on ML and Monte Carlo Cross Validation}
\usage{
CCI.test(
  formula = NULL,
  data,
  p = 0.5,
  nperm = 60,
  nrounds = 600,
  metric = "Auto",
  method = "rf",
  choose_direction = FALSE,
  parametric = FALSE,
  poly = TRUE,
  degree = 3,
  subsample = 1,
  min_child_weight = 1,
  colsample_bytree = 1,
  eta = 0.3,
  gamma = 0,
  max_depth = 6,
  interaction = TRUE,
  metricfunc = NULL,
  mlfunc = NULL,
  tail = NA,
  tune = FALSE,
  samples = 35,
  folds = 5,
  tune_length = 10,
  seed = NA,
  random_grid = TRUE,
  nthread = 1,
  verbose = FALSE,
  progress = TRUE,
  ...
)
}
\arguments{
\item{formula}{Model formula specifying the relationship between dependent and independent variables. (Ex: Y ~ X | Z1 + Z2 for Y \emph{||} X | Z1, Z2)}

\item{data}{A data frame containing the variables specified in the formula.}

\item{p}{Numeric. Proportion of data used for training the model. Default is 0.5.}

\item{nperm}{Integer. The number of permutations to perform. Default is 60.}

\item{nrounds}{Integer. The number of rounds (trees) for methods 'xgboost' and 'rf' Default is 600.}

\item{metric}{Character. Specifies the type of data: "Auto", "RMSE" or "Kappa". Default is "Auto".}

\item{method}{Character. Specifies the machine learning method to use. Supported methods include generlaized linear models "lm", random forest "rf", and extreme gradient boosting "xgboost", etc. Default is "rf".#'}

\item{choose_direction}{Logical. If TRUE, the function will choose the best direction for testing. Default is FALSE.}

\item{parametric}{Logical, indicating whether to compute a parametric p-value instead of the empirical p-value. A parametric p-value assumes that the null distribution is gaussian. Default is FALSE.}

\item{poly}{Logical. If TRUE, polynomial terms of the conditional variables are included in the model. Default is TRUE.}

\item{degree}{Integer. The degree of polynomial terms to include if poly is TRUE. Default is 3.}

\item{subsample}{Numeric. The proportion of data to use for subsampling. Default is 1 (no subsampling).}

\item{min_child_weight}{Numeric. The minimum sum of instance weight (hessian) needed in a child for methods like xgboost. Default is 1.}

\item{colsample_bytree}{Numeric. The subsample ratio of columns when constructing each tree for methods like xgboost. Default is 1.}

\item{eta}{Numeric. The learning rate for methods like xgboost. Default is 0.3.}

\item{gamma}{Numeric. The minimum loss reduction required to make a further partition on a leaf node of the tree for methods like xgboost. Default is 0.}

\item{max_depth}{Integer. The maximum depth of the trees for methods like xgboost. Default is 6.}

\item{interaction}{Logical. If TRUE, interaction terms of the conditional variables are included in the model. Default is TRUE.}

\item{metricfunc}{Optional the user can pass a custom function for calculating a performance metric based on the model's predictions. Default is NULL.}

\item{mlfunc}{Optional the user can pass a custom machine learning wrapper function to use instead of the predefined methods. Default is NULL.}

\item{tail}{Character. Specifies whether to calculate left-tailed or right-tailed p-values, depending on the performance metric used. Only applicable if using \code{metricfunc} or \code{mlfunc}. Default is NA.}

\item{tune}{Logical. If TRUE, the function will perform hyperparameter tuning for the specified machine learning method. Default is FALSE.}

\item{samples}{Integer. Number of hyperparameter combinations used in tuning. Default is 35.}

\item{folds}{Integer. The number of folds for cross-validation during the tuning process. Default is 5.}

\item{tune_length}{Integer. The number of parameter combinations to try during the tuning process. Default is 10.}

\item{seed}{Integer. Set the seed for reproducing results. Default is NA.}

\item{random_grid}{Logical. If TRUE, a random grid search is performed. If FALSE, a full grid search is performed. Default is TRUE.}

\item{nthread}{Integer. The number of threads to use for parallel processing. Default is 1.}

\item{verbose}{Logical. If TRUE, additional information is printed during the execution of the function. Default is FALSE.}

\item{progress}{Logical. If TRUE, a progress bar is displayed during the permutation process. Default is TRUE.}

\item{...}{Additional arguments to pass to the \code{perm.test} function.}
}
\value{
Invisibly returns the result of \code{perm.test}, which is an object of class 'CCI' containing the null distribution, observed test statistic, p-values, the machine learning model used, and the data.
}
\description{
The \code{CCI.test} function performs a conditional independence test using a specified machine learning model or a custom model provided by the user. It calculates the test statistic, generates a null distribution via permutations, computes p-values, and optionally generates a plot of the null distribution with the observed test statistic.
The 'CCI.test' function serves as a wrapper around the 'perm.test' function
}
\examples{
set.seed(123)
data <- data.frame(x1 = stats::rnorm(100), x2 = stats::rnorm(100), y = stats::rnorm(100))
result <- CCI.test(y ~ x1 | x2, data = data, nperm = 25, interaction = FALSE)
summary(result)
}
\seealso{
\code{\link{perm.test}}, \code{\link{print.summary.CCI}}, \code{\link{plot.CCI}}, \code{\link{CCI.pretuner}}, \code{\link{QQplot}}
}
