% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CCMnet_theoretical_check.R
\name{CCM_theoretical_check}
\alias{CCM_theoretical_check}
\title{Compare MCMC Estimates with Theoretical Distributions}
\usage{
CCM_theoretical_check(fit, n_sim = nrow(fit$mcmc_stats))
}
\arguments{
\item{fit}{An object returned by \code{ccm_sample}.}

\item{n_sim}{The number of samples drawn from the theoretical distribution}
}
\value{
A diagnostic plot comparing empirical and theoretical distributions.
}
\description{
This function compares the empirical MCMC distribution from \code{sample_ccm}
with the theoretical distribution from the CCM model. It is used as a diagnostic
tool to evaluate model adequacy.
}
\examples{
ccm_sample <- sample_ccm(
  network_stats = list("edges"),
  prob_distr = list("poisson"),
  prob_distr_params = list(list(350)),
  population = 50 
)
ccm_sample<- CCM_theoretical_check(ccm_sample, n_sim = 1000)
plot(ccm_sample, stats = "edges", type = "hist", include_theoretical = TRUE)

}
