% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute.R
\name{appendPermanent}
\alias{appendPermanent}
\alias{append_permanent}
\title{Run a dplyr query and add the result set to an existing}
\usage{
appendPermanent(x, name, schema = NULL)

append_permanent(x, name, schema = NULL)
}
\arguments{
\item{x}{A dplyr query}

\item{name}{Name of the table to be appended. If it does not already exist it
will be created.}

\item{schema}{Schema where the table exists. Can be a length 1 or 2 vector.
(e.g. schema = "my_schema", schema = c("my_schema", "dbo"))}
}
\value{
A dplyr reference to the newly created table
}
\description{
Run a dplyr query and add the result set to an existing

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
}
\examples{
\dontrun{
library(CDMConnector)

con <- DBI::dbConnect(duckdb::duckdb(), dbdir = eunomiaDir())
concept <- dplyr::tbl(con, "concept")

# create a table
rxnorm_count <- concept \%>\%
  dplyr::filter(domain_id == "Drug") \%>\%
  dplyr::mutate(isRxnorm = (vocabulary_id == "RxNorm")) \%>\%
  dplyr::count(domain_id, isRxnorm) \%>\%
  compute("rxnorm_count")

# append to an existing table
rxnorm_count <- concept \%>\%
  dplyr::filter(domain_id == "Procedure") \%>\%
  dplyr::mutate(isRxnorm = (vocabulary_id == "RxNorm")) \%>\%
  dplyr::count(domain_id, isRxnorm) \%>\%
  appendPermanent("rxnorm_count")

DBI::dbDisconnect(con, shutdown = TRUE)

}
}
