# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' This is the Gibbs sampler for CDSeq.
#' \code{GibbsSampler} returns estimated GEPs and cell type proportions.
#' @param ALPHA hyperparameter for cell type proportion.
#' @param BETA hyperparameter for cell-type-specific GEPs.
#' @param mixtureSamples bulk RNA-seq data in form of read counts.
#' @param T number of cell types.
#' @param NN number of MCMC iteration.
#' @param OUTPUT MCMC progress output control.
#' @param processID worker process ID when using parallel computing.
#' @param data_block_idx index for data blocks from bulk RNA-seq input.
#' @param CDSeq_tmp_log temporary log file recording the workers' jobs.
#' @param write_2_file print to progress msg to CDSeq_tmp_log if it is 1, not printing otherwise.
#' @param verbose if greater than or euqal to 1, then print working progress in console, otherwise do not print in console.
#' @return random integers  uniformly distributed in 0..(2^32 - 1).
gibbsSampler <- function(ALPHA, BETA, mixtureSamples, T, NN, OUTPUT, processID, data_block_idx, CDSeq_tmp_log, write_2_file, verbose) {
    .Call('_CDSeq_gibbsSampler', PACKAGE = 'CDSeq', ALPHA, BETA, mixtureSamples, T, NN, OUTPUT, processID, data_block_idx, CDSeq_tmp_log, write_2_file, verbose)
}

#' This is the Mersenne Twister random number generator.
#' \code{cokus} generates pseudorandom integers uniformly distributed in 0..(2^32 - 1).
#' @param seed odd number for seeding
#' @return random integers  uniformly distributed in 0..(2^32 - 1).
#' @author Shawn Cokus (Cokus@@math.washington.edu)
seedMT <- function(seed) {
    invisible(.Call('_CDSeq_seedMT', PACKAGE = 'CDSeq', seed))
}

randomMT <- function() {
    .Call('_CDSeq_randomMT', PACKAGE = 'CDSeq')
}

#' This is the Hungarian algorithm wrapper for cell type assignment
#' \code{hungarian_Rcpp} returns cell type assignment given reference GEPs
#' @param costMat correlation matrix
#' @return cost for the assignment and cell type assignment
hungarian_Rcpp <- function(costMat) {
    .Call('_CDSeq_hungarian_Rcpp', PACKAGE = 'CDSeq', costMat)
}

