% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_both_arms_sim.R
\docType{data}
\name{sample_data}
\alias{sample_data}
\alias{run_both_arms_sim}
\title{This is data to be included in my package}
\usage{
run_both_arms_sim(trans_prob_mat_drug, trans_prob_mat_no_drug, util_drug,
  util_no_drug, cost_drug, cost_no_drug, time_horizon,
  inital_state_vec_drug, inital_state_vec_no_drug, dead_state_num_drug,
  dead_state_num_no_drug, discount_rate, cycle_length)
}
\arguments{
\item{trans_prob_mat_drug}{transition matrix for the drug arm}

\item{trans_prob_mat_no_drug}{transition matrix for the no drug arm}

\item{util_drug}{utility vector for the drug arm}

\item{util_no_drug}{utility vector for the no drug arm}

\item{cost_drug}{cost vector for the drug arm}

\item{cost_no_drug}{cost vector for the no drug arm}

\item{time_horizon}{null for lifetime horizon or number of years}

\item{inital_state_vec_drug}{initial state vector for the drug arm}

\item{inital_state_vec_no_drug}{initial state vector for the no drug arm}

\item{dead_state_num_drug}{number of dead states in the drug arm}

\item{dead_state_num_no_drug}{number of dead states in the no drug arm}

\item{discount_rate}{discount rate in percentages}

\item{cycle_length}{cycle length in years}
}
\value{
list
}
\description{
This is data to be included in my package
}
\examples{
prob_vec<-extract_prob(initial_age=45,selected_country='Ethiopia',
time_horizon=NULL,gender = 'Female',selected_year=2015,cycle_length = (1/12),
prob_data = sample_data)

drug_arm_5_years<-matrix(data = c(0,0.029,0.087*0.59,0,0,0.1,0,0.261*0.59,
0,0,0,0,0,0.325,0,0,0,0,1,0,0,0,0,0,1),nrow = 5,ncol = 5,byrow = TRUE)
both_arms_after_20_years<-matrix(data = c(0,0,0,0,0,0.1,0,0.261,0,0,0,0,
0,0.325,0,0,0,0,1,0,0,0,0,0,1),nrow = 5,ncol = 5,byrow = TRUE)
after_5_years_drug_arm_no_drug_arm_5<-matrix(data = c(0,0.029,0.087,0,0,
0.1,0,0.261,0,0,0,0,0,0.325,0,0,0,0,1,0,0,0,0,0,1),nrow = 5,ncol = 5,byrow = TRUE)

drug_arm_5_years<-change_current_prob_to_cycle_prob(drug_arm_5_years,1,(1/12))
both_arms_after_20_years<-change_current_prob_to_cycle_prob(both_arms_after_20_years,1,(1/12))
after_5_years_drug_arm_no_drug_arm_5<-change_current_prob_to_cycle_prob(
after_5_years_drug_arm_no_drug_arm_5,1,(1/12))

drug_arm<-array(c(replicate(n=5*12,drug_arm_5_years),replicate(n=15*12,
after_5_years_drug_arm_no_drug_arm_5),replicate(n=40*12,
both_arms_after_20_years)),dim = c(5,5,60*12))
no_drug_arm<-array(c(replicate(n=20*12,after_5_years_drug_arm_no_drug_arm_5),
replicate(n=40*12,both_arms_after_20_years)),dim = c(5,5,60*12))

up_mat<-prepare_trans_matrix(drug_arm,prob_vec,(1/12))
up_mat_no_drug<-prepare_trans_matrix(no_drug_arm,prob_vec,(1/12))

cost_vec_ethiopia<-c(0,1323/12,1841/12,0,0)
cost_vec_12_months<-c(20000,1323/12,1841/12,0,0)

util_vec<-c(0.94,0.82,0.58,0,0)
total_cost_vec_no_drug_arm<-t(replicate(n=60*12,cost_vec_ethiopia))
total_util_vec_drug<-t(replicate(n=60*12,util_vec))
total_util_vec_no_drug<-total_util_vec_drug

total_cost_drug_arm<-t(cbind(replicate(n=1,cost_vec_12_months),
replicate(n=59*12+11,cost_vec_ethiopia)))

ini_vec<-c(1,0,0,0,0)

run_both_arms_sim(up_mat,up_mat_no_drug,total_util_vec_drug,total_util_vec_no_drug,
total_cost_drug_arm,total_cost_vec_no_drug_arm,NULL,ini_vec,ini_vec,2,2,
covert_discount_rate(3,1/12),(1/12))
}
\references{
http://apps.who.int/gho/data/?theme=main&vid=60550
}
\keyword{This}
\keyword{Title}
\keyword{WHO,}
\keyword{all-cause}
\keyword{arms}
\keyword{both}
\keyword{for}
\keyword{function}
\keyword{mortality}
\keyword{probability}
\keyword{runs}
\keyword{simulation}
\keyword{the}
