% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/distanceCalculation.R
\name{distanceVector}
\alias{distanceVector}
\title{Calculate Distance Vector}
\usage{
distanceVector(a, X, distFun)
}
\arguments{
\item{a}{A single sample which is a suitable input for \code{distFun}}

\item{X}{list of samples, where each list element is a suitable input for \code{distFun}}

\item{distFun}{Distance function of type f(x,y)=r, where r is a scalar and x and y are elements whose distance is evaluated.}
}
\value{
A numerical vector of distances
}
\description{
Calculate the distance between a single sample and all samples in a list.
}
\examples{
x <- 1:5
y <- list(5:1,c(2,4,5,1,3),c(5,4,3,1,2))
distanceVector(x,y,distancePermutationHamming)
}

