% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indefiniteLearning.R
\name{correctionDefinite}
\alias{correctionDefinite}
\title{Correcting Definiteness of a Matrix}
\usage{
correctionDefinite(mat, type = "PSD", method = "flip", tol = 1e-08)
}
\arguments{
\item{mat}{symmetric matrix}

\item{type}{string that specifies type of correction: \code{"PSD"},\code{"NSD"} to enforce PSD or NSD matrices respectively.}

\item{method}{string that specifies method for correction: spectrum clip \code{"clip"}, spectrum flip \code{"flip"}, nearest definite matrix \code{"near"}, spectrum square\code{"square"}, spectrum diffusion \code{"diffusion"}.}

\item{tol}{torelance value. Eigenvalues between \code{-tol} and \code{tol} are assumed to be zero.}
}
\value{
list with\cr 
corrected matrix \code{mat},\cr 
\code{isIndefinite} (boolean, whether original matrix was indefinite),\cr
the eigenvalues of the original matrix (\code{lambda}),\cr
the eigenvalues of the corrected matrix (\code{lambdanew}),\cr
the matrix of eigenvectors (\code{U}),
the transformation vector (\code{a})
}
\description{
Correcting a (possibly indefinite) symmetric matrix with chosen approach so that it will have desired definiteness type: positive or negative semi-definite (PSD, NSD).
}
\examples{
x <- list(c(2,1,4,3),c(2,4,3,1),c(4,2,1,3),c(4,3,2,1),c(1,4,3,2))
D <- distanceMatrix(x,distancePermutationInsert)
is.NSD(D) #matrix should not be CNSD
D <- correctionDefinite(D,type="NSD")$mat
is.NSD(D) #matrix should now be CNSD
# different example: PSD kernel
D <- distanceMatrix(x,distancePermutationInsert)
K <- exp(-0.01*D)
is.PSD(K)
K <- correctionDefinite(K,type="PSD")$mat
is.PSD(K)
}
\references{
Martin Zaefferer and Thomas Bartz-Beielstein. (2016). Efficient Global Optimization with Indefinite Kernels. Parallel Problem Solving from Nature-PPSN XIV. Accepted, in press. Springer.
}
\seealso{
\code{\link{modelKriging}}
}

