% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isDefinite.R
\name{is.CNSD}
\alias{is.CNSD}
\title{Check for Conditional Negative Semi-Definiteness}
\usage{
is.CNSD(X, method = "alg1", tol = 1e-08)
}
\arguments{
\item{X}{a symmetric matrix}

\item{method}{a string, specifiying the method to be used. \code{"alg1"} is based on algorithm 1 in Ikramov and Savel'eva (2000). 
\code{"alg2"} is based on theorem 3.2 in Ikramov and Savel'eva (2000). \code{"eucl"} is based on Glunt (1990).}

\item{tol}{torelance value. Eigenvalues between \code{-tol} and \code{tol} are assumed to be zero.

Symmetric, CNSD matrices are, e.g., euclidean distance matrices, whiche are required to produce Positive Semi-Definite correlation
or kernel matrices. Such matrices are used in models like Kriging or Support Vector Machines.}
}
\value{
boolean, which is TRUE if X is CNSD
}
\description{
This function checks whether a symmetric matrix is Conditionally Negative Semi-Definite (CNSD).
Note that this function does not check whether the matrix is actually symmetric.
}
\examples{
# The following permutations will produce
# a non-CNSD distance matrix with Insert distance
# and a CNSD distance matrix with Hamming distance
x <- list(c(2,1,4,3),c(2,4,3,1),c(4,2,1,3),c(4,3,2,1),c(1,4,3,2))
D <- distanceMatrix(x,distancePermutationInsert)
is.CNSD(D,"alg1")
is.CNSD(D,"alg2")
is.CNSD(D,"eucl")
D <- distanceMatrix(x,distancePermutationHamming)
is.CNSD(D,"alg1")
is.CNSD(D,"alg2")
is.CNSD(D,"eucl")
}
\references{
Ikramov, K. and Savel'eva, N. Conditionally definite matrices, Journal of Mathematical Sciences, Kluwer Academic Publishers-Plenum Publishers, 2000, 98, 1-50

Glunt, W.; Hayden, T. L.; Hong, S. and Wells, J. An alternating projection algorithm for computing the nearest Euclidean distance matrix, SIAM Journal on Matrix Analysis and Applications, SIAM, 1990, 11, 589-600
}
\seealso{
\code{\link{is.NSD}}, \code{\link{is.PSD}}
}

