% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isDefinite.R
\name{is.PSD}
\alias{is.PSD}
\title{Check for Positive Semi-Definiteness}
\usage{
is.PSD(X, tol = 1e-08)
}
\arguments{
\item{X}{a symmetric matrix}

\item{tol}{torelance value. Eigenvalues between \code{-tol} and \code{tol} are assumed to be zero.

Symmetric, PSD matrices are, e.g., correlation
or kernel matrices. Such matrices are used in models like Kriging or Support Vector regression.}
}
\value{
boolean, which is TRUE if X is PSD
}
\description{
This function checks whether a symmetric matrix is Positive Semi-Definite (PSD).
That means, it is determined whether all eigenvalues of the matrix are non-negative.
Note that this function does not check whether the matrix is actually symmetric.
}
\examples{
# The following permutations will produce
# a non-PSD kernel matrix with Insert distance
# and a PSD distance matrix with Hamming distance
# (for the given theta value of 0.01)
x <- list(c(2,1,4,3),c(2,4,3,1),c(4,2,1,3),c(4,3,2,1),c(1,4,3,2))
K <- exp(-0.01*distanceMatrix(x,distancePermutationInsert))
is.PSD(K)
K <- exp(-0.01*distanceMatrix(x,distancePermutationHamming))
is.PSD(K)
}
\seealso{
\code{\link{is.CNSD}}, \code{\link{is.NSD}}
}

