% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelKrigingLikelihood.R
\name{modelKrigingParameterizedLikelihood}
\alias{modelKrigingParameterizedLikelihood}
\title{Calculate negative log-likelihood}
\usage{
modelKrigingParameterizedLikelihood(xt, xs, ys, useLambda = FALSE,
  corr = fcorrGauss, indefiniteMethod = "none",
  indefiniteType = "PSD", indefiniteRepair = FALSE,
  returnLikelihoodOnly = TRUE, inverter = "chol", distanceFunction,
  combineDistances, distanceParametersLower, ntheta, scaling)
}
\arguments{
\item{xt}{vector, containing parameters like theta, p and lambda.}

\item{xs}{training samples, which are the input for the distance function. Should be in list format.}

\item{ys}{vector of observations at training sample locations.}

\item{useLambda}{whether to use nugget effect, i.e., lambda (FALSE at default).}

\item{corr}{whether to use nugget effect, i.e., lambda (fcorrGauss at default).}

\item{indefiniteMethod}{The specific method used for correction: spectrum \code{"clip"}, spectrum \code{"flip"}, spectrum \code{"square"}, spectrum \code{"diffusion"}, feature embedding "feature", nearest definite matrix "near". Default is no correction: \code{"none"}. See Zaefferer and Bartz-Beielstein (2016).}

\item{indefiniteType}{The general type of correction for indefiniteness: \code{"NSD"},\code{"CNSD"} or the default \code{"PSD"}. See Zaefferer and Bartz-Beielstein (2016).}

\item{indefiniteRepair}{boolean, whether conditions of the distance matrix (in case of \code{"NSD"},\code{"CNSD"} correction type) or correlation matrix (in case of \code{"PSD"} correction type) are repaired.}

\item{returnLikelihoodOnly}{boolean, whether the function should return only the likelihood, or a else a list (see return information below).}

\item{inverter}{string specifying method for inversion of correlation matrix ("chol", cholesky decomposition at default, any other string leads to using the solve function).}

\item{distanceFunction}{the distance function.}

\item{combineDistances}{boolean, whether to combine several distances provided as a list of distance functions.}

\item{distanceParametersLower}{lower boundary for the distance function(s) parameters. A vector in case of one distance, a list of vectors in case of several functions. The parameters are passed as a vector to each respective distance function.}

\item{ntheta}{number of kernel parameters.}

\item{scaling}{boolean, whether to scale the distance matrix.}
}
\value{
the numeric Likelihood value (if \code{returnLikelihoodOnly} is TRUE) or a list with elements:
\describe{
\item{\code{NegLnLike}}{ concentrated log-likelihood *-1 for minimising}
\item{\code{Psi}}{ correlation matrix}
\item{\code{Psinv}}{ inverse of correlation matrix (to save computation time in forrRegPredictor)}
\item{\code{mu}}{ MLE of model parameter mu }
\item{\code{yMu}}{ vector of observations y minus mu}
\item{\code{SSQ}}{ MLE of model parameter sigma^2}
\item{\code{a}}{ transformation vector for eigenspectrum transformation, see Zaefferer and Bartz-Beielstein (2016)}
\item{\code{U}}{ Matrix of eigenvectors for eigenspectrum transformation, see Zaefferer and Bartz-Beielstein (2016)}
\item{\code{isIndefinite}}{ whether the uncorrected correlation (kernel) matrix is indefinite}
}
}
\description{
This is a wrapper for the Kriging likelihood function \code{\link{modelKrigingLikelihood}}.
It is intended for the case where parameters of the distance function are also optimized
during maximum likelihood estimation. Thus, the wrapper receives the data, computes the
parameterized distance matrix and passes it to the standard likelihood function.
}
\seealso{
\code{\link{modelKrigingLikelihood}}
}
\keyword{internal}
