% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimMIES.R
\name{optimMIES}
\alias{optimMIES}
\title{Mixed Integer Evolution Strategy (MIES)}
\usage{
optimMIES(x = NULL, fun, control = list())
}
\arguments{
\item{x}{Optional start individual(s) as a list. If NULL (default), \code{creationFunction} (in \code{control} list) is used to create initial design. 
If \code{x} has less individuals than the population size, creationFunction will fill up the rest.}

\item{fun}{target function to be minimized.}

\item{control}{(list), with the options:
\describe{
  \item{\code{budget}}{The limit on number of target function evaluations (stopping criterion) (default: 1000).}
  \item{\code{popsize}}{Population size (default: 100).}
  \item{\code{generations}}{Number of generations (stopping criterion) (default: Inf).}
  \item{\code{targetY}}{Target function value (stopping criterion) (default: -Inf).}
  \item{\code{vectorized}}{Boolean. Defines whether target function is vectorized (takes a list of solutions as argument) or not (takes single solution as argument). Default: FALSE.}
  \item{\code{verbosity}}{Level of text output during run. Defaults to 0, no output.}
  \item{\code{plotting}}{Plot optimization progress during run (TRUE) or not (FALSE). Default is FALSE.}
  \item{\code{archive}}{Whether to keep all candidate solutions and their fitness in an archive (TRUE) or not (FALSE). Default is TRUE.}
  \item{\code{stoppingCriterionFunction}}{Custom additional stopping criterion. Function evaluated on the population, receiving all individuals (list) and their fitness (vector). If the result is FALSE, the algorithm stops.}
  \item{\code{types}}{A vector that specifies the data type of each variable: "numeric", "integer" or "factor".}
  \item{\code{lower}}{Lower bound of each variable. Factor variables can have the lower bound set to NA.}
  \item{\code{upper}}{Upper bound of each variable. Factor variables can have the upper bound set to NA.}
  \item{\code{levels}}{List of levels for each variable (only relevant for categorical variables). 
Should be a vector of numerical values, usually integers, but not necessarily a sequence.
HAS to be given if any factors/categoricals are present. Else, set to NA.}
}}
}
\value{
a list:
\describe{
  \item{\code{xbest}}{best solution found.}
  \item{\code{ybest}}{fitness of the best solution.}
  \item{\code{x}}{history of all evaluated solutions.}
  \item{\code{y}}{corresponding target function values f(x).}
  \item{\code{count}}{number of performed target function evaluations.}
  \item{\code{message}}{Termination message: Which stopping criterion was reached.}
  \item{\code{population}}{Last population.}
  \item{\code{fitness}}{Fitness of last population.}
}
}
\description{
An optimization algorithm from the family of Evolution Strategies, designed to
optimize mixed-integer problems: The search space is composed of continuous (real-valued) parameters,
ordinal integers and categorical parameters.
Please note that the categorical parameters need to be coded as integers 
(type should not be a factor or character).
It is an implementation (with a slight modification) of MIES as described by Li et al. (2013).
Note, that this algorithm always has a step size for each solution parameter, unlike Li et al.,
we did not include the option to change to a single step-size for all parameters.
Dominant recombination is used for solution parameters (the search space parameters), 
intermediate recombination for strategy parameters (i.e., step sizes).
Mutation: Self-adaptive, step sizes sigma are optimized alongside the solution parameters. 
Real-valued parameters are subject to variation based on independent normal distributed random variables. 
Ordinal integers are subject to variation based on the difference of geometric distributions. 
Categorical parameters are changed at random, with a self-adapted probability.
Note, that a more simple bound constraint method is used. Instead of the Transformation T_{a,b}(x) 
described by Li et al., optimMIES simply replaces any value that exceeds the bounds by respective boundary value.
}
\details{
The control variables types, lower, upper and levels are especially important.
}
\examples{
set.seed(1)
controlList <- list(lower=c(-5,-5,1,1,NA,NA),upper=c(10,5,10,10,NA,NA),
		types=c("numeric","numeric","integer","integer","factor","factor"),
	levels=list(NA,NA,NA,NA,c(1,3,5),1:4),
		vectorized = FALSE)
objFun <- function(x){		
		x[[3]] <- round(x[[3]])
		x[[4]] <- round(x[[4]])
		y <- sum(as.numeric(x[1:4])^2) 
		if(x[[5]]==1 & x[[6]]==4)
			y <- exp(y)
		else
			y <- y^2
		if(x[[5]]==3)
			y<-y-1	
		if(x[[5]]==5)
			y<-y-2	
		if(x[[6]]==1)
			y<-y*2
		if(x[[6]]==2)
			y<-y * 1.54
		if(x[[6]]==3)
			y<- y +2
		if(x[[6]]==4)
			y<- y * 0.5	
		if(x[[5]]==1)
			y<- y * 9	
		y	
	}
res <- optimMIES(,objFun,controlList)
res$xbest
res$ybest

}
\references{
Rui Li, Michael T. M. Emmerich, Jeroen Eggermont, Thomas Baeck, Martin Schuetz, Jouke Dijkstra, and Johan H. C. Reiber. 2013. Mixed integer evolution strategies for parameter optimization. Evol. Comput. 21, 1 (March 2013), 29-64.
}
\seealso{
\code{\link{optimCEGO}}, \code{\link{optimRS}}, \code{\link{optimEA}}, \code{\link{optim2Opt}}, \code{\link{optimMaxMinDist}}
}
