% Generated by roxygen2 (4.0.2): do not edit by hand
\docType{data}
\name{Scopus_SourceList}
\alias{Scopus_SourceList}
\title{Scopus covered source list}
\format{\preformatted{ NULL
}}
\usage{
Scopus_SourceList
}
\description{
List of Elsevier's \emph{SciVerse Scopus} covered titles (journals, conference proceedings, book series, etc.)
}
\details{
Last update: October 2011. The data file is based on the official and publicly available
(no permission needed as stated by Elsevier) Scopus list of covered titles,
see \url{http://www.info.sciverse.com/documents/files/scopus-training/resourcelibrary/xls/title_list.xls}.

This data frame consists of 30794 records.
It has the following columns.
\tabular{ll}{
  \code{SourceId} \tab Unique source identifier in \emph{SciVerse Scopus} (integer). \cr
  \code{Title} \tab Title of the source. \cr
  \code{Status} \tab Status of the source, either \code{Active} or \code{Inactive}. \cr
  \code{SJR_2009} \tab SCImago Journal Rank 2009. \cr
  \code{SNIP_2009} \tab Source Normalized Impact per Paper 2009. \cr
  \code{SJR_2010} \tab SCImago Journal Rank 2010. \cr
  \code{SNIP_2010} \tab Source Normalized Impact per Paper 2010. \cr
  \code{SJR_2011} \tab SCImago Journal Rank 2011. \cr
  \code{SNIP_2011} \tab Source Normalized Impact per Paper 2011. \cr
  \code{OpenAccess} \tab Type of Open Access, see below. \cr
  \code{Type} \tab Type of the source, see below. \cr
  \code{ASJC} \tab A list of semicolon-separated ASJC classification codes, see \code{\link{Scopus_ASJC}}. \cr
}

\code{OpenAccess} is one of \code{DOAJ}, \code{Not OA} (not Open Access source),
\code{OA but not registered}, \code{OA registered}.

\code{Type} is one of \code{Book Series}, \code{Conference Proceedings}, \code{Journal}, \code{Trade Journal}

The \code{data.frame} is sorted by \code{Status} (\code{Active} sources first) and then by \code{SJR_2011} (higher values first).
}
\references{
\url{http://www.info.sciverse.com/scopus/scopus-in-detail/facts/}\cr
\url{http://info.scopus.com/journalmetrics/sjr.html}\cr
\url{http://info.scopus.com/journalmetrics/snip.html}\cr
}
\seealso{
\code{\link{Scopus_ASJC}}, \code{\link{Scopus_ReadCSV}}, \code{\link{Scopus_ImportSources}}
}
\keyword{ASJC,}
\keyword{Scopus,}
\keyword{conference,}
\keyword{journal,}
\keyword{proceedings}

