% Generated by roxygen2 (4.0.2): do not edit by hand
\name{lbsImportDocuments}
\alias{lbsImportDocuments}
\title{Import bibliographic data into a Local Bibliometric Storage.}
\usage{
lbsImportDocuments(conn, data, surveyDescription = "Default survey",
  surnameFirstnameCommaSeparated = FALSE, originalFilename = attr(data,
  "filename"), excludeRows = NULL, updateDocumentIfExists = TRUE,
  warnSourceTitle = TRUE, warnExactDuplicates = FALSE, verbose = TRUE)
}
\arguments{
\item{conn}{a connection object, see \code{\link{lbsConnect}}.}

\item{data}{11 column \code{data.frame} with bibliometric entries; see above.}

\item{surveyDescription}{description of the survey. Allows for documents grouping.}

\item{surnameFirstnameCommaSeparated}{logical; indicates wher surnames are separated from first names (or initials) by comma or by space (\code{FALSE}, default).}

\item{originalFilename}{original filename; \code{attr(data, "filename")} used by default.}

\item{excludeRows}{a numeric vector with row numbers of \code{data} to be excluded or \code{NULL}.}

\item{updateDocumentIfExists}{logical; if \code{TRUE} then documents with existing \code{AlternativeId} will be updated.}

\item{warnSourceTitle}{logical; if \code{TRUE} then warnings are generated if a given SourceTitle is not found in \code{Biblio_Sources}.}

\item{warnExactDuplicates}{logical; \code{TRUE} to warn if exact duplicates are found (turned off by default).}

\item{verbose}{logical; \code{TRUE} to display progress information.}
}
\value{
\code{TRUE} on success.
}
\description{
Imports bibliographic data from a special 11-column \code{data.frame} object
(see e.g. \code{\link{Scopus_ReadCSV}}) into a Local Bibliometric Storage.
}
\details{
\code{data} must consist of the following 11 columns (in order). Otherwise
the process will not be executed.
\tabular{llll}{
1  \tab \code{Authors}       \tab character\tab  Author(s) name(s), comma-separated, surnames first.\cr
2  \tab \code{Title}         \tab character\tab  Document title.\cr
3  \tab \code{Year}          \tab numeric  \tab  Year of publication.\cr
4  \tab \code{SourceTitle}   \tab character\tab  Title of the source containing the document.\cr
5  \tab \code{Volume}        \tab character\tab  Volume.\cr
6  \tab \code{Issue}         \tab character\tab  Issue.\cr
7  \tab \code{PageStart}     \tab numeric  \tab  Start page; numeric.\cr
8  \tab \code{PageEnd}       \tab numeric  \tab  End page; numeric.\cr
9  \tab \code{Citations}     \tab numeric  \tab  Number of citations; numeric.\cr
10 \tab \code{AlternativeId} \tab character\tab  Alternative document identifier. \cr
11 \tab \code{DocumentType}  \tab factor   \tab  Type of the document.\cr
}

\code{DocumentType} is one of \dQuote{Article}, \dQuote{Article in Press},
       \dQuote{Book}, \dQuote{Conference Paper}, \dQuote{Editorial}, \dQuote{Erratum},
       \dQuote{Letter}, \dQuote{Note}, \dQuote{Report},
       \dQuote{Review}, \dQuote{Short Survey}, or \code{NA} (other categories are interpreted as \code{NA}).

Note that if \code{data} contains a large number of records (>1000),
the whole process may take a few minutes.

Sources (e.g. journals) are identified by SourceTitle (table \code{Biblio_Sources}).
Note that generally there is no need to concern about missing SourceTitles of
conference proceedings.

Each time a function is called, a new record in the table \code{Biblio_Surveys}
is created. Such surveys may be grouped using the \code{Description}
field, see \code{\link{lbsCreate}}.
}
\examples{
\dontrun{
conn <- lbsConnect("Bibliometrics.db");
## ...
data <- Scopus_ReadCSV("db_Polish_MATH/Poland_MATH_1987-1993.csv");
lbsImportDocuments(conn, data, "Poland_MATH");
## ...
lbsDisconnect(conn);}
}
\seealso{
\code{\link{Scopus_ReadCSV}}, \code{\link{lbsConnect}}, \code{\link{lbsCreate}}
}

