% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downsample_pairs.R
\name{downsample_pairs}
\alias{downsample_pairs}
\title{downsample the number of individuals sampled}
\usage{
downsample_pairs(S, P, n)
}
\arguments{
\item{S}{the tibble of samples with columns at least of \code{ID} and \code{samp_years_list}. Typically
this will be what is returned in the \code{samples} component from \code{slurp_spip()}.}

\item{P}{the tibble of pairs. Typically this will be what has been returned from
\code{compile_related_pairs()}.}

\item{n}{The desired number of individuals (or instances, really, see below) to
retain in the sample.}
}
\value{
This returns a list with two components as follows:
\itemize{
\item \code{ds_samples}: A tibble like \code{S} except having randomly removed individuals
so as to only have n left.
\item \code{ds_pairs}: A tibble like \code{P} except having removed any pairs that
include individuals that were not retained in the sample.
}
}
\description{
This discards individuals from the sample, randomly, until
the desired number of samples is achieved, then it
returns only those pairs in which both members are part of
the retained samples.
}
\examples{
# prepare some input
S <- three_pops_with_mig_slurped_results$samples
P <- compile_related_pairs(three_pops_with_mig_slurped_results$samples)
result <- downsample_pairs(S, P, n = 500)

# print the result
result
}
