% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install_spip.R
\name{install_spip}
\alias{install_spip}
\title{Download the spip binary and install it where CKMRpop expects it}
\usage{
install_spip(Dir = tempfile())
}
\arguments{
\item{Dir}{the directory to install spip into.  Because of restrictions
on functions writing to the user's home filespace, this is set, by default,
to a temporary directory.  But to really use this function to install spip,
this parameter must be set to \code{system.file(package = "CKMRpop")}.}
}
\value{
No return value.  Called for side effect of installing the 'spip' binary.
}
\description{
This checks the operating system and installs the correct version
(either Darwin or Linux for Mac or Linux, respectively.)  To install
the spip binary this function downloads it from its GitHub site.  It also
installs a windows implementation of awk.
}
\examples{
\dontrun{
install_spip(Dir = system.file(package = "CKMRpop"))
}
}
