% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duty_factor_transformer_33_66kv.R
\name{duty_factor_transformer_33_66kv}
\alias{duty_factor_transformer_33_66kv}
\title{Duty Factor for 33/10kV and 66/10kV Transformers and Tapchanger}
\source{
DNO Common Network Asset Indices Methodology (CNAIM),
Health & Criticality - Version 1.1, 2017:
\url{https://www.ofgem.gov.uk/system/files/docs/2017/05/dno_common_network_asset_indices_methodology_v1.1.pdf}
}
\usage{
duty_factor_transformer_33_66kv(
  utilisation_pct = "Default",
  no_taps = "Default"
)
}
\arguments{
\item{utilisation_pct}{Numeric. The max percentage of utilisation
under normal operating conditions.}

\item{no_taps}{Numeric. Average number of daily taps (tapchanger).}
}
\value{
Data table. Duty factor for the transformer and for the tapcharger
}
\description{
This function calculates the duty factor for
33/10kV and 66/10kV transformers depending on the maximum
percentage utilisation under normal operating conditions. And the tapchanger
depending on the average number of daily taps.
The duty factor is used in the deriviation of the expected life of an asset.
See e.g. \code{\link{expected_life}}(). For more general information about
the derivation of the duty factor see section 6.6 on page 47 in CNAIM (2017)
}
\examples{
duty_factor_transformer_33_66kv(utilisation_pct = 95,
no_taps = 25)
}
