% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cof_hv_switchgear_distribution.R
\name{financial_cof_hv_switchgear_distribution}
\alias{financial_cof_hv_switchgear_distribution}
\title{Financial cost of Failure for HV swicthgear distribution}
\source{
DNO Common Network Asset Indices Methodology (CNAIM),
Health & Criticality - Version 1.1, 2017:
\url{https://www.ofgem.gov.uk/system/files/docs/2017/05/dno_common_network_asset_indices_methodology_v1.1.pdf}
}
\usage{
financial_cof_hv_switchgear_distribution(
  hv_asset_category,
  access_factor_criteria
)
}
\arguments{
\item{hv_asset_category}{String The type of HV switchgear distribution asset category}

\item{access_factor_criteria}{String. Asses Financial factor criteria for LV switchgear
setting (cf. table 214, page 164, CNAIM, 2017).}
}
\value{
Numeric. Financial consequences of failure for LV switchgear
}
\description{
This function calculates financial consequences of failure
(cf. section 7.3, page 75, CNAIM, 2017). Financial consequences
of failure is used in
the derivation of consequences of failure see \code{\link{cof}}().
}
\examples{
financial_cof_hv_switchgear_distribution(
hv_asset_category = "6.6/11kV CB (GM) Secondary",
access_factor_criteria = "Type A")
}
