% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cof_lv_switchgear_and_other.R
\name{network_cof_lv_switchgear_and_other}
\alias{network_cof_lv_switchgear_and_other}
\title{Network cost of Failure for LV swicthgear and others}
\source{
DNO Common Network Asset Indices Methodology (CNAIM),
Health & Criticality - Version 1.1, 2017:
\url{https://www.ofgem.gov.uk/system/files/docs/2017/05/dno_common_network_asset_indices_methodology_v1.1.pdf}
}
\usage{
network_cof_lv_switchgear_and_other(
  lv_asset_category,
  no_customers,
  kva_per_customer = "Default"
)
}
\arguments{
\item{lv_asset_category}{String The type of LV asset category}

\item{no_customers}{Numeric. The numner of customers
fed by an individual asset.}

\item{kva_per_customer}{Numeric. If the asset have an exceptionally high
demand per customer type in kVA per customer. A setting of \code{"Default"}
results in a multiplication factor of 1 (cf. table 18, page 86, CNAIM, 2017).}
}
\value{
Numeric. Network cost of failure.
}
\description{
This function calculates network cost of failure for
all asset categories exclusive the assets EHV and 132kV transformers.
(cf. section 7.6, page 83, CNAIM, 2017). Network cost of failure
is used in the derivation of consequences of failure see \code{\link{cof}}().
}
\examples{
network_cof_lv_switchgear_and_other(lv_asset_category = "LV Board (WM)",
no_customers = 750, kva_per_customer = 51)
}
