% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cof_transformer_30_60kv.R
\name{financial_cof_transformer_30_60kv}
\alias{financial_cof_transformer_30_60kv}
\title{Financial cost of Failure for 30/10 kV and 60/10 kV Transformers}
\usage{
financial_cof_transformer_30_60kv(
  tf_asset_category,
  type_financial_factor_kva_mva = NULL,
  access_factor_criteria
)
}
\arguments{
\item{tf_asset_category}{String The type of Transformer asset category
Options: \code{tf_asset_category = c("30kV Transformer (GM)",
"60kV Transformer (GM)")}.}

\item{type_financial_factor_kva_mva}{Numeric The type financial factor kVA MVA for Transformer}

\item{access_factor_criteria}{String. Asses Financial factor criteria for Transformer
setting (cf. table 221, page 180, CNAIM, 2021).
Options: \code{access_factor_criteria = c("Type A", "Type B", "Type C")}.}
}
\value{
Numeric. Financial consequences of failure for Transformer
}
\description{
This function calculates financial consequences of failure
Outputted in DKK.
}
\examples{
financial_cof_transformer_30_60kv(tf_asset_category = "30kV Transformer (GM)",
type_financial_factor_kva_mva = 20,
access_factor_criteria = "Type A")
}
