% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalise.R
\name{Normalise.numeric}
\alias{Normalise.numeric}
\title{Normalise a numeric vector}
\usage{
\method{Normalise}{numeric}(x, f_n = NULL, f_n_para = NULL, direction = 1, ...)
}
\arguments{
\item{x}{Object to be normalised}

\item{f_n}{The normalisation method, specified as string which refers to a function of the form \code{f_n(x, npara)}.
See details. Defaults to \code{"n_minmax"} which is the min-max function.}

\item{f_n_para}{Supporting list of arguments for \code{f_n}. This is required to be a list.}

\item{direction}{If \code{direction = -1} the highest values of \code{x} will correspond to the lowest
values of the normalised \code{x}. Else if \code{direction = 1} the direction of \code{x} in unaltered.}

\item{...}{arguments passed to or from other methods.}
}
\value{
A normalised numeric vector
}
\description{
Normalise a numeric vector using a specified function \code{f_n}, with possible reversal of direction
using \code{direction}.
}
\details{
Normalisation is specified using the \code{f_n} and \code{f_n_para} arguments. In these, \code{f_n} should be a character
string which is the name of a normalisation
function. For example, \code{f_n = "n_minmax"} calls the \code{\link[=n_minmax]{n_minmax()}} function. \code{f_n_para} is a list of any
further arguments to \code{f_n}. This means that any function can be passed to \code{\link[=Normalise]{Normalise()}}, as long as its
first argument is \code{x}, a numeric vector, and it returns a numeric vector of the same length. See \code{\link[=n_minmax]{n_minmax()}}
for an example.

\code{f_n_para} is \emph{required} to be a named list. So e.g. if we define a function \code{f1(x, arg1, arg2)} then we should
specify \code{f_n = "f1"}, and \code{f_n_para = list(arg1 = val1, arg2 = val2)}, where \code{val1} and \code{val2} are the
values assigned to the arguments \code{arg1} and \code{arg2} respectively.

See also \code{vignette("normalise")} for more details.
}
\examples{
# example vector
x <- runif(10)

# normalise using distance to reference (5th data point)
x_norm <- Normalise(x, f_n = "n_dist2ref", f_n_para = list(iref = 5))

# view side by side
data.frame(x, x_norm)

}
