% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/results.R
\name{get_unit_summary}
\alias{get_unit_summary}
\title{Generate unit summary table}
\usage{
get_unit_summary(coin, usel, Levels, dset = "Aggregated", nround = 2)
}
\arguments{
\item{coin}{A coin}

\item{usel}{A selected unit code}

\item{Levels}{The aggregation levels to display results from.}

\item{dset}{The data set within the coin to extract scores and ranks from}

\item{nround}{Number of decimals to round scores to, default 2.}
}
\value{
A summary table as a data frame, containing scores and ranks for specified indicators/aggregates.
}
\description{
Generates a summary table for a single unit. This is mostly useful in unit reports.
}
\details{
This returns the scores and ranks for each indicator/aggregate as specified in \code{aglevs}. It orders the table so that
the highest aggregation levels are first. This means that if the index level is included, it will be first.
}
\examples{
# build full example coin
coin <- build_example_coin(quietly = TRUE)

# summary of scores for IND at levels 4, 3 and 2
get_unit_summary(coin, usel = "IND", Levels = c(4,3,2), dset = "Aggregated")

}
