% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/COMBIA.R
\name{readFluostarPlates}
\alias{readFluostarPlates}
\title{Read a file containing raw read outs and calculates survival values.
This function calculates survival values as
(survival value= treated - empty/ untreated control- empty) of the wells specified
in the wells argument. Wells argument should  be in triplet form, they are,  untreated control well range, empty well range and treated well range.
The function also handles the double plate experiments in which one plate is read twice and only one of them is selected.}
\usage{
readFluostarPlates(filename, separator = ",", noofrows_skip = 0,
  sheet = "1", readplates = 1, platetype, doubleplateexperiment = FALSE,
  keyposition, selectionkey, platekey, rowsperexperiment = 1, wells)
}
\arguments{
\item{filename}{filename.ext.}

\item{separator}{It is the separation character within the file assigned to filename.}

\item{noofrows_skip}{Number of the rows to skip in in data file.}

\item{sheet}{Sheet number conataining data in a workbook.}

\item{readplates}{Number of the plates to read from a set of plates from an excel file, This feature is only useful with spreadsheet files.}

\item{platetype}{Two types of plate formats (384 and 96) are supported.}

\item{doubleplateexperiment}{This parameter value can either be TRUE or FALSE. It is TRUE when an experiment is read twice.}

\item{keyposition}{Position of barcode in the header.}

\item{selectionkey}{Value, that is used to select one of double read outs.}

\item{platekey}{Barcode of data plate.}

\item{rowsperexperiment}{It is the argument that specifies if the same experiment is repeated
and how many times in a plate. If an experiment is repeated twice in adjacent rows then average
of its values will be used in the survival value calculation.}

\item{wells}{Well ranges to read data.}
}
\value{
Matrix containing survival values.
}
\description{
Read a file containing raw read outs and calculates survival values.
This function calculates survival values as
(survival value= treated - empty/ untreated control- empty) of the wells specified
in the wells argument. Wells argument should  be in triplet form, they are,  untreated control well range, empty well range and treated well range.
The function also handles the double plate experiments in which one plate is read twice and only one of them is selected.
}
\examples{
f <- system.file("/raw/optima.log", package="COMBIA")
platematrix <-readFluostarPlates(filename=f, platetype="384", keyposition=2,
selectionkey="65000",platekey=7051,
 wells=c( "c8:h8","c1:n1","c3:c7",    "c8:h8","c1:n1","c9:c11",
        "c8:h8","c1:n1","g3:g7",    "c8:h8","c1:n1","g9:g11",

       "i8:n8","c1:n1","i3:i7",     "i8:n8","c1:n1","i9:i11",
       "i8:n8","c1:n1","k3:k7",     "i8:n8","c1:n1","k9:k11",
       "i8:n8","c1:n1","m3:m7",     "i8:n8","c1:n1","m9:m11",

       "c18:h18","c1:n1","c14:c17",     "c18:h18","c1:n1","c19:c22",
       "i18:n18","c1:n1","m14:m17",     "i18:n18","c1:n1","m19:m22",
       "i18:n18","c1:n1","m13:m13"

      )
   )
}
\author{
Muhammad Kashif
}

