% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/COMBIA.R
\name{selectPlate}
\alias{selectPlate}
\title{Select one of the two read plates and built a hashtable.
One plate from each pair of the read plate is selected in case of double plate experinment on the basis of presence 
of minimum selection key and if none have maxed out values then one with highest mean value is picked.}
\usage{
selectPlate(rawdata, processedbarcode, numberofrowsperplate, selectionkey,
  doubleplateexperiment)
}
\arguments{
\item{rawdata}{An object(dataframe) of rawdata.}

\item{processedbarcode}{A vector of regenerated missing keyvalues. In this case it is the output of function "extractKey".}

\item{numberofrowsperplate}{This argument is not needed when you call function "readFluostarPlates". The number of rows depends upon the
geometry of the plates. These are 16 in case of 384well paltes.}

\item{selectionkey}{keyvalue on basis of which a plate is slected from a pair of plates read in double plate experiment.}

\item{doubleplateexperiment}{This parameter can have TRUE & FALSE values only. It is set to TRUE when an experiment is read twice.}
}
\value{
A hashtable of picked plates.
}
\description{
Select one of the two read plates and built a hashtable.
One plate from each pair of the read plate is selected in case of double plate experinment on the basis of presence 
of minimum selection key and if none have maxed out values then one with highest mean value is picked.
}
\examples{
f <- system.file("extdata", "optima.log", package="COMBIA")
fileDF <- readFile(filename = f, separator = "\\t", noofrows_skip=0,
                   platetype = "384") 
Generatedbarcode <- Generatedbarcode <- extractKey(keyposition = 2,
    rawdata = fileDF, numberofrowsperplate = 17, doubleplateexperiment = TRUE) 
hashedplates <-  selectPlate(rawdata = fileDF,
    processedbarcode = Generatedbarcode, numberofrowsperplate=17,
    selectionkey="65000", doubleplateexperiment = TRUE  )
}
\author{
Muhammad Kashif
}
