% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ChangePointTests.R
\name{andrews_test}
\alias{andrews_test}
\title{Univariate Andrews Test for End-of-Sample Structural Change}
\usage{
andrews_test(x, M, pval = TRUE, stat = TRUE)
}
\arguments{
\item{x}{Vector of the data to test}

\item{M}{Numeric index of the location of the first potential change point}

\item{pval}{If \code{TRUE}, return a p-value}

\item{stat}{If \code{TRUE}, return a test statistic}
}
\value{
If both \code{pval} and \code{stat} are \code{TRUE}, a list
        containing both; otherwise, a number for one or the other, depending
        on which is \code{TRUE}
}
\description{
This implements Andrews' test for end-of-sample change, as described by
\insertCite{andrews03;textual}{CPAT}. This test was derived for detecting a
change in univariate data. See \insertCite{andrews03}{CPAT} for
a description of the test.
}
\examples{
CPAT:::andrews_test(rnorm(1000), M = 900)
}
\references{
\insertAllCited{}
}
